/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.data.builder.dialect;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereDatabaseData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereRowData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereSchemaData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereTableData;
import org.apache.shardingsphere.infra.metadata.data.builder.ShardingSphereDataBuilder;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;

public final class MySQLShardingSphereDataBuilder
implements ShardingSphereDataBuilder {
    private static final String SHARDING_SPHERE = "shardingsphere";
    private static final String CLUSTER_INFORMATION = "cluster_information";

    @Override
    public ShardingSphereData build(ShardingSphereMetaData metaData) {
        ShardingSphereData result = new ShardingSphereData();
        Optional<ShardingSphereSchema> shardingSphereSchema = Optional.ofNullable(metaData.getDatabase(SHARDING_SPHERE)).map(database -> database.getSchema(SHARDING_SPHERE));
        if (!shardingSphereSchema.isPresent()) {
            return result;
        }
        ShardingSphereSchemaData schemaData = new ShardingSphereSchemaData();
        for (Map.Entry<String, ShardingSphereTable> entry : shardingSphereSchema.get().getTables().entrySet()) {
            ShardingSphereTableData tableData = new ShardingSphereTableData(entry.getValue().getName());
            if (CLUSTER_INFORMATION.equals(entry.getKey())) {
                tableData.getRows().add(new ShardingSphereRowData(Collections.singletonList("5.3.1")));
            }
            schemaData.getTableData().put(entry.getKey(), tableData);
        }
        ShardingSphereDatabaseData databaseData = new ShardingSphereDatabaseData();
        databaseData.getSchemaData().put(SHARDING_SPHERE, schemaData);
        result.getDatabaseData().put(SHARDING_SPHERE, databaseData);
        return result;
    }

    public String getType() {
        return "MySQL";
    }
}

