/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.yaml.config.swapper.rule;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.util.spi.type.ordered.OrderedSPIRegistry;
import org.apache.shardingsphere.infra.util.yaml.YamlConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;

public final class YamlRuleConfigurationSwapperEngine {
    public Collection<YamlRuleConfiguration> swapToYamlRuleConfigurations(Collection<RuleConfiguration> ruleConfigs) {
        return OrderedSPIRegistry.getRegisteredServices(YamlRuleConfigurationSwapper.class, ruleConfigs).entrySet().stream().map(entry -> (YamlRuleConfiguration)((YamlRuleConfigurationSwapper)entry.getValue()).swapToYamlConfiguration(entry.getKey())).collect(Collectors.toList());
    }

    public Collection<RuleConfiguration> swapToRuleConfigurations(Collection<YamlRuleConfiguration> yamlRuleConfigs) {
        LinkedList<RuleConfiguration> result = new LinkedList<RuleConfiguration>();
        Collection ruleConfigTypes = yamlRuleConfigs.stream().map(YamlRuleConfiguration::getRuleConfigurationType).collect(Collectors.toList());
        for (Map.Entry entry : OrderedSPIRegistry.getRegisteredServicesByClass(YamlRuleConfigurationSwapper.class, (Collection)ruleConfigTypes).entrySet()) {
            result.addAll(this.swapToRuleConfigurations(yamlRuleConfigs, (Class)entry.getKey(), (YamlRuleConfigurationSwapper)entry.getValue()));
        }
        return result;
    }

    private Collection<RuleConfiguration> swapToRuleConfigurations(Collection<YamlRuleConfiguration> yamlRuleConfigs, Class<?> ruleConfigType, YamlRuleConfigurationSwapper swapper) {
        return yamlRuleConfigs.stream().filter(each -> each.getRuleConfigurationType().equals(ruleConfigType)).map(each -> (RuleConfiguration)swapper.swapToObject((YamlConfiguration)each)).collect(Collectors.toList());
    }
}

