/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.data.builder.dialect;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shardingsphere.infra.database.type.dialect.PostgreSQLDatabaseType;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereDatabaseData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereRowData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereSchemaData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereTableData;
import org.apache.shardingsphere.infra.metadata.data.builder.ShardingSphereDataBuilder;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;

public final class PostgreSQLShardingSphereDataBuilder
implements ShardingSphereDataBuilder {
    private static final Map<String, Collection<String>> COLLECTED_SCHEMA_TABLES = new LinkedHashMap<String, Collection<String>>();
    private static final Map<String, Collection<String>> INIT_DATA_SCHEMA_TABLES = new LinkedHashMap<String, Collection<String>>();

    @Override
    public ShardingSphereData build(ShardingSphereMetaData metaData) {
        ShardingSphereData result = new ShardingSphereData();
        for (Map.Entry<String, ShardingSphereDatabase> entry : metaData.getDatabases().entrySet()) {
            if (new PostgreSQLDatabaseType().getSystemDatabaseSchemaMap().containsKey(entry.getKey())) continue;
            ShardingSphereDatabaseData databaseData = new ShardingSphereDatabaseData();
            this.appendSchemaData(entry.getValue(), databaseData);
            result.getDatabaseData().put(entry.getKey(), databaseData);
        }
        return result;
    }

    private void appendSchemaData(ShardingSphereDatabase shardingSphereDatabase, ShardingSphereDatabaseData databaseData) {
        for (Map.Entry<String, ShardingSphereSchema> entry : shardingSphereDatabase.getSchemas().entrySet()) {
            if (!COLLECTED_SCHEMA_TABLES.containsKey(entry.getKey()) && !INIT_DATA_SCHEMA_TABLES.containsKey(entry.getKey())) continue;
            ShardingSphereSchemaData schemaData = new ShardingSphereSchemaData();
            this.appendTableData(entry, schemaData);
            databaseData.getSchemaData().put(entry.getKey(), schemaData);
        }
    }

    private void appendTableData(Map.Entry<String, ShardingSphereSchema> schemaEntry, ShardingSphereSchemaData schemaData) {
        for (Map.Entry<String, ShardingSphereTable> entry : schemaEntry.getValue().getTables().entrySet()) {
            ShardingSphereTableData tableData = new ShardingSphereTableData(entry.getValue().getName());
            if (null != COLLECTED_SCHEMA_TABLES.get(schemaEntry.getKey()) && COLLECTED_SCHEMA_TABLES.get(schemaEntry.getKey()).contains(entry.getKey())) {
                schemaData.getTableData().put(entry.getKey(), tableData);
            }
            if (null == INIT_DATA_SCHEMA_TABLES.get(schemaEntry.getKey()) || !INIT_DATA_SCHEMA_TABLES.get(schemaEntry.getKey()).contains(entry.getKey())) continue;
            tableData.getRows().add(new ShardingSphereRowData(Collections.singletonList("5.3.2")));
            schemaData.getTableData().put(entry.getKey(), tableData);
        }
    }

    public String getType() {
        return "PostgreSQL";
    }

    static {
        COLLECTED_SCHEMA_TABLES.put("shardingsphere", Collections.singletonList("sharding_table_statistics"));
        COLLECTED_SCHEMA_TABLES.put("pg_catalog", Arrays.asList("pg_class", "pg_namespace"));
        INIT_DATA_SCHEMA_TABLES.put("shardingsphere", Collections.singletonList("cluster_information"));
    }
}

