/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.database.impl.DataSourceProvidedDatabaseConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.datasource.state.DataSourceStateManager;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.metadata.database.resource.ShardingSphereResourceMetaData;
import org.apache.shardingsphere.infra.metadata.database.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilder;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterial;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.SystemSchemaBuilder;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.builder.database.DatabaseRulesBuilder;
import org.apache.shardingsphere.infra.rule.identifier.type.MutableDataNodeRule;

public final class ShardingSphereDatabase {
    private final String name;
    private final DatabaseType protocolType;
    private final ShardingSphereResourceMetaData resourceMetaData;
    private final ShardingSphereRuleMetaData ruleMetaData;
    private final Map<String, ShardingSphereSchema> schemas;

    public ShardingSphereDatabase(String name, DatabaseType protocolType, ShardingSphereResourceMetaData resourceMetaData, ShardingSphereRuleMetaData ruleMetaData, Map<String, ShardingSphereSchema> schemas) {
        this.name = name;
        this.protocolType = protocolType;
        this.resourceMetaData = resourceMetaData;
        this.ruleMetaData = ruleMetaData;
        this.schemas = new ConcurrentHashMap<String, ShardingSphereSchema>(schemas.size(), 1.0f);
        schemas.forEach((key, value) -> this.schemas.put(key.toLowerCase(), (ShardingSphereSchema)value));
    }

    public static ShardingSphereDatabase create(String name, DatabaseType protocolType, Map<String, DatabaseType> storageTypes, DatabaseConfiguration databaseConfig, ConfigurationProperties props, InstanceContext instanceContext) throws SQLException {
        Collection<ShardingSphereRule> databaseRules = DatabaseRulesBuilder.build(name, databaseConfig, instanceContext);
        ConcurrentHashMap<String, ShardingSphereSchema> schemas = new ConcurrentHashMap<String, ShardingSphereSchema>();
        schemas.putAll(GenericSchemaBuilder.build(new GenericSchemaBuilderMaterial(protocolType, storageTypes, DataSourceStateManager.getInstance().getEnabledDataSourceMap(name, databaseConfig.getDataSources()), databaseRules, props, DatabaseTypeEngine.getDefaultSchemaName(protocolType, name))));
        schemas.putAll(SystemSchemaBuilder.build(name, protocolType));
        return ShardingSphereDatabase.create(name, protocolType, databaseConfig, databaseRules, schemas);
    }

    public static ShardingSphereDatabase create(String name, DatabaseType protocolType) {
        DataSourceProvidedDatabaseConfiguration databaseConfig = new DataSourceProvidedDatabaseConfiguration(new LinkedHashMap<String, DataSource>(), new LinkedList<RuleConfiguration>());
        return ShardingSphereDatabase.create(name, protocolType, databaseConfig, new LinkedList<ShardingSphereRule>(), SystemSchemaBuilder.build(name, protocolType));
    }

    public static ShardingSphereDatabase create(String name, DatabaseType protocolType, DatabaseConfiguration databaseConfig, Collection<ShardingSphereRule> rules, Map<String, ShardingSphereSchema> schemas) {
        ShardingSphereResourceMetaData resourceMetaData = ShardingSphereDatabase.createResourceMetaData(name, databaseConfig.getDataSources());
        ShardingSphereRuleMetaData ruleMetaData = new ShardingSphereRuleMetaData(rules);
        return new ShardingSphereDatabase(name, protocolType, resourceMetaData, ruleMetaData, schemas);
    }

    private static ShardingSphereResourceMetaData createResourceMetaData(String databaseName, Map<String, DataSource> dataSourceMap) {
        return new ShardingSphereResourceMetaData(databaseName, dataSourceMap);
    }

    public ShardingSphereSchema getSchema(String schemaName) {
        return this.schemas.get(schemaName.toLowerCase());
    }

    public void putSchema(String schemaName, ShardingSphereSchema schema) {
        this.schemas.put(schemaName.toLowerCase(), schema);
    }

    public void removeSchema(String schemaName) {
        this.schemas.remove(schemaName.toLowerCase());
    }

    public boolean containsSchema(String schemaName) {
        return this.schemas.containsKey(schemaName.toLowerCase());
    }

    public boolean isComplete() {
        return !this.ruleMetaData.getRules().isEmpty() && !this.resourceMetaData.getDataSources().isEmpty();
    }

    public boolean containsDataSource() {
        return !this.resourceMetaData.getDataSources().isEmpty();
    }

    public synchronized void reloadRules(Class<? extends ShardingSphereRule> ruleClass) {
        Collection<? extends ShardingSphereRule> toBeReloadedRules = this.ruleMetaData.findRules(ruleClass);
        RuleConfiguration ruleConfig = toBeReloadedRules.stream().map(ShardingSphereRule::getConfiguration).findFirst().orElse(null);
        LinkedList<ShardingSphereRule> databaseRules = new LinkedList<ShardingSphereRule>(this.ruleMetaData.getRules());
        toBeReloadedRules.stream().findFirst().ifPresent(optional -> {
            databaseRules.removeAll(toBeReloadedRules);
            databaseRules.add(((MutableDataNodeRule)optional).reloadRule(ruleConfig, this.name, this.resourceMetaData.getDataSources(), databaseRules));
        });
        this.ruleMetaData.getRules().clear();
        this.ruleMetaData.getRules().addAll(databaseRules);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public DatabaseType getProtocolType() {
        return this.protocolType;
    }

    @Generated
    public ShardingSphereResourceMetaData getResourceMetaData() {
        return this.resourceMetaData;
    }

    @Generated
    public ShardingSphereRuleMetaData getRuleMetaData() {
        return this.ruleMetaData;
    }

    @Generated
    public Map<String, ShardingSphereSchema> getSchemas() {
        return this.schemas;
    }
}

