/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.user;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import lombok.Generated;

public final class Grantee {
    private final String username;
    private final String hostname;
    private final boolean isUnlimitedHost;
    private final int hashCode;
    private final String toString;

    public Grantee(String username, String hostname) {
        this.username = username;
        this.hostname = Strings.isNullOrEmpty((String)hostname) ? "%" : hostname;
        this.isUnlimitedHost = "%".equals(this.hostname);
        this.hashCode = this.isUnlimitedHost ? username.toUpperCase().hashCode() : Objects.hashCode((Object[])new Object[]{username.toUpperCase(), hostname.toUpperCase()});
        this.toString = username + "@" + hostname;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Grantee) {
            Grantee grantee = (Grantee)obj;
            return grantee.username.equalsIgnoreCase(this.username) && this.isPermittedHost(grantee);
        }
        return false;
    }

    private boolean isPermittedHost(Grantee grantee) {
        return this.isUnlimitedHost || grantee.hostname.equalsIgnoreCase(this.hostname);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.toString;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }
}

