/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.metadata.dialect;

import com.google.common.base.Strings;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.metadata.DataSourceMetaData;
import org.apache.shardingsphere.infra.database.metadata.UnrecognizedDatabaseURLException;

public final class SQLServerDataSourceMetaData
implements DataSourceMetaData {
    private static final int DEFAULT_PORT = 1433;
    private static final Pattern URL_PATTERN = Pattern.compile("jdbc:(microsoft:)?sqlserver://([\\w\\-\\.]+):?(\\d*);\\S*(DatabaseName|database)=([\\w\\-\\.]+);?", 2);
    private final String hostname;
    private final int port;
    private final String catalog;
    private final String schema;

    public SQLServerDataSourceMetaData(String url) {
        Matcher matcher = URL_PATTERN.matcher(url);
        if (!matcher.find()) {
            throw new UnrecognizedDatabaseURLException(url, URL_PATTERN.pattern());
        }
        this.hostname = matcher.group(2);
        this.port = Strings.isNullOrEmpty((String)matcher.group(3)) ? 1433 : Integer.parseInt(matcher.group(3));
        this.catalog = matcher.group(5);
        this.schema = null;
    }

    @Override
    public Properties getQueryProperties() {
        return new Properties();
    }

    @Override
    public Properties getDefaultQueryProperties() {
        return new Properties();
    }

    @Override
    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Override
    @Generated
    public int getPort() {
        return this.port;
    }

    @Override
    @Generated
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    @Generated
    public String getSchema() {
        return this.schema;
    }
}

