/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.type.checker;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.UnsupportedStorageTypeException;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.util.spi.type.typed.TypedSPILoader;

public final class DatabaseTypeChecker {
    private static final Collection<String> MOCKED_URL_PREFIXES = new HashSet<String>(Arrays.asList("jdbc:fixture", "jdbc:mock", "mock:jdbc"));
    private static final Collection<String> UNSUPPORTED_URL_PREFIXES = Collections.singletonList("jdbc:mysql:aws");
    private static final Collection<DatabaseType> SUPPORTED_STORAGE_TYPES = new HashSet<DatabaseType>(8, 1.0f);
    private static volatile boolean isChecked;

    public static void checkSupportedStorageTypes(Map<String, DataSource> dataSources, String databaseName, Map<String, DatabaseType> storageTypes) throws SQLException {
        if (isChecked || dataSources.isEmpty()) {
            return;
        }
        for (Map.Entry<String, DataSource> entry : dataSources.entrySet()) {
            Connection connection = entry.getValue().getConnection();
            try {
                String url = connection.getMetaData().getURL();
                if (MOCKED_URL_PREFIXES.stream().anyMatch(url::startsWith)) {
                    return;
                }
                ShardingSpherePreconditions.checkState((boolean)UNSUPPORTED_URL_PREFIXES.stream().noneMatch(url::startsWith), () -> new UnsupportedStorageTypeException(databaseName, (String)entry.getKey()));
            }
            finally {
                if (connection == null) continue;
                connection.close();
            }
        }
        storageTypes.forEach((key, value) -> ShardingSpherePreconditions.checkState((boolean)SUPPORTED_STORAGE_TYPES.stream().anyMatch(each -> each.getClass().equals(value.getClass())), () -> new UnsupportedStorageTypeException(databaseName, (String)key)));
        isChecked = true;
    }

    public static void checkSupportedStorageType(String url, String dataSourceName) {
        if (MOCKED_URL_PREFIXES.stream().anyMatch(url::startsWith)) {
            return;
        }
        ShardingSpherePreconditions.checkState((boolean)UNSUPPORTED_URL_PREFIXES.stream().noneMatch(url::startsWith), () -> new UnsupportedStorageTypeException(dataSourceName));
        ShardingSpherePreconditions.checkState((boolean)SUPPORTED_STORAGE_TYPES.stream().flatMap(storageType -> storageType.getJdbcUrlPrefixes().stream()).anyMatch(url::startsWith), () -> new UnsupportedStorageTypeException(dataSourceName));
    }

    @Generated
    private DatabaseTypeChecker() {
    }

    static {
        Arrays.asList("MySQL", "PostgreSQL", "openGauss", "Oracle", "SQLServer", "H2", "MariaDB").forEach(each -> TypedSPILoader.findService(DatabaseType.class, (String)each).ifPresent(SUPPORTED_STORAGE_TYPES::add));
    }
}

