/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.pool.destroyer.detector.type;

import javax.sql.DataSource;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.detector.DataSourcePoolActiveDetector;

public final class HikariDataSourcePoolActiveDetector
implements DataSourcePoolActiveDetector {
    @Override
    public boolean containsActiveConnection(DataSource dataSource) {
        return 0 != this.getActiveConnections(dataSource);
    }

    private int getActiveConnections(DataSource dataSource) {
        Object hikariPoolMXBean = dataSource.getClass().getMethod("getHikariPoolMXBean", new Class[0]).invoke((Object)dataSource, new Object[0]);
        return null == hikariPoolMXBean ? 0 : (Integer)hikariPoolMXBean.getClass().getMethod("getActiveConnections", new Class[0]).invoke(hikariPoolMXBean, new Object[0]);
    }

    public String getType() {
        return "com.zaxxer.hikari.HikariDataSource";
    }
}

