/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.loader.common;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.SchemaSupportedDatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.adapter.MetaDataLoaderConnectionAdapter;

public final class SchemaMetaDataLoader {
    private static final String TABLE_TYPE = "TABLE";
    private static final String VIEW_TYPE = "VIEW";
    private static final String SYSTEM_TABLE_TYPE = "SYSTEM TABLE";
    private static final String SYSTEM_VIEW_TYPE = "SYSTEM VIEW";
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final String TABLE_SCHEME = "TABLE_SCHEM";

    public static Map<String, Collection<String>> loadSchemaTableNames(String databaseName, DatabaseType databaseType, DataSource dataSource) throws SQLException {
        try (MetaDataLoaderConnectionAdapter connectionAdapter = new MetaDataLoaderConnectionAdapter(databaseType, dataSource.getConnection());){
            Collection<String> schemaNames = SchemaMetaDataLoader.loadSchemaNames(connectionAdapter, databaseType);
            HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>(schemaNames.size(), 1.0f);
            for (String each : schemaNames) {
                String schemaName = databaseType instanceof SchemaSupportedDatabaseType ? each : databaseName;
                result.put(schemaName, SchemaMetaDataLoader.loadTableNames(connectionAdapter, each));
            }
            HashMap<String, Collection<String>> hashMap = result;
            return hashMap;
        }
    }

    public static Collection<String> loadSchemaNames(Connection connection, DatabaseType databaseType) throws SQLException {
        if (!(databaseType instanceof SchemaSupportedDatabaseType)) {
            return Collections.singletonList(connection.getSchema());
        }
        LinkedList<String> result = new LinkedList<String>();
        try (ResultSet resultSet = connection.getMetaData().getSchemas();){
            while (resultSet.next()) {
                String schema = resultSet.getString(TABLE_SCHEME);
                if (databaseType.getSystemSchemas().contains(schema)) continue;
                result.add(schema);
            }
        }
        return result.isEmpty() ? Collections.singletonList(connection.getSchema()) : result;
    }

    private static Collection<String> loadTableNames(Connection connection, String schemaName) throws SQLException {
        LinkedList<String> result = new LinkedList<String>();
        try (ResultSet resultSet = connection.getMetaData().getTables(connection.getCatalog(), schemaName, null, new String[]{TABLE_TYPE, VIEW_TYPE, SYSTEM_TABLE_TYPE, SYSTEM_VIEW_TYPE});){
            while (resultSet.next()) {
                String table = resultSet.getString(TABLE_NAME);
                if (SchemaMetaDataLoader.isSystemTable(table)) continue;
                result.add(table);
            }
        }
        return result;
    }

    private static boolean isSystemTable(String table) {
        return table.contains("$") || table.contains("/") || table.contains("##");
    }

    @Generated
    private SchemaMetaDataLoader() {
    }
}

