/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datanode;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datanode.DataNodeBuilder;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.attribute.datanode.DataNodeRuleAttribute;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;

public final class DataNodes {
    private final Collection<ShardingSphereRule> rules;
    private final Map<ShardingSphereRule, DataNodeBuilder> dataNodeBuilders;

    public DataNodes(Collection<ShardingSphereRule> rules) {
        this.rules = rules;
        this.dataNodeBuilders = OrderedSPILoader.getServices(DataNodeBuilder.class, rules);
    }

    public Collection<DataNode> getDataNodes(String tableName) {
        Collection<DataNode> result = new LinkedList<DataNode>(this.rules.stream().map(each -> this.getDataNodes((ShardingSphereRule)each, tableName)).filter(dataNodes -> !dataNodes.isEmpty()).findFirst().orElse(Collections.emptyList()));
        for (Map.Entry<ShardingSphereRule, DataNodeBuilder> entry : this.dataNodeBuilders.entrySet()) {
            result = entry.getValue().build(result, entry.getKey());
        }
        return result;
    }

    private Collection<DataNode> getDataNodes(ShardingSphereRule rule, String tableName) {
        return rule.getAttributes().findAttribute(DataNodeRuleAttribute.class).map(optional -> optional.getDataNodesByTableName(tableName)).orElse(Collections.emptyList());
    }

    @Generated
    public DataNodes(Collection<ShardingSphereRule> rules, Map<ShardingSphereRule, DataNodeBuilder> dataNodeBuilders) {
        this.rules = rules;
        this.dataNodeBuilders = dataNodeBuilders;
    }
}

