/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.statistics.builder.dialect;

import java.util.Collections;
import java.util.Map;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereDatabaseData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereRowData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereSchemaData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereTableData;
import org.apache.shardingsphere.infra.metadata.statistics.builder.ShardingSphereStatisticsBuilder;

public final class MySQLShardingSphereStatisticsBuilder
implements ShardingSphereStatisticsBuilder {
    private static final String SHARDING_SPHERE = "shardingsphere";
    private static final String CLUSTER_INFORMATION = "cluster_information";
    private static final String SHARDING_TABLE_STATISTICS = "sharding_table_statistics";

    @Override
    public ShardingSphereStatistics build(ShardingSphereMetaData metaData) {
        ShardingSphereStatistics result = new ShardingSphereStatistics();
        for (Map.Entry<String, ShardingSphereDatabase> entry : metaData.getDatabases().entrySet()) {
            ShardingSphereDatabaseData databaseData = new ShardingSphereDatabaseData();
            this.initSchemas(entry.getValue(), databaseData);
            if (databaseData.getSchemaData().isEmpty()) continue;
            result.putDatabase(entry.getKey(), databaseData);
        }
        return result;
    }

    private void initSchemas(ShardingSphereDatabase database, ShardingSphereDatabaseData databaseData) {
        for (Map.Entry<String, ShardingSphereSchema> entry : database.getSchemas().entrySet()) {
            if (!SHARDING_SPHERE.equals(entry.getKey())) continue;
            ShardingSphereSchemaData schemaData = new ShardingSphereSchemaData();
            this.initClusterInformationTable(schemaData);
            this.initShardingTableStatisticsTable(schemaData);
            databaseData.putSchema(SHARDING_SPHERE, schemaData);
        }
    }

    private void initClusterInformationTable(ShardingSphereSchemaData schemaData) {
        ShardingSphereTableData tableData = new ShardingSphereTableData(CLUSTER_INFORMATION);
        tableData.getRows().add(new ShardingSphereRowData(Collections.singletonList("5.5.0")));
        schemaData.putTable(CLUSTER_INFORMATION, tableData);
    }

    private void initShardingTableStatisticsTable(ShardingSphereSchemaData schemaData) {
        schemaData.putTable(SHARDING_TABLE_STATISTICS, new ShardingSphereTableData(SHARDING_TABLE_STATISTICS));
    }

    public String getDatabaseType() {
        return "MySQL";
    }
}

