/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.reviser.column;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.metadata.data.model.ColumnMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.reviser.MetaDataReviseEntry;
import org.apache.shardingsphere.infra.metadata.database.schema.reviser.column.ColumnExistedReviser;
import org.apache.shardingsphere.infra.metadata.database.schema.reviser.column.ColumnGeneratedReviser;
import org.apache.shardingsphere.infra.metadata.database.schema.reviser.column.ColumnNameReviser;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class ColumnReviseEngine<T extends ShardingSphereRule> {
    private final T rule;
    private final MetaDataReviseEntry<T> reviseEntry;

    public Collection<ColumnMetaData> revise(String tableName, Collection<ColumnMetaData> originalMetaDataList) {
        Optional<ColumnExistedReviser> existedReviser = this.reviseEntry.getColumnExistedReviser(this.rule, tableName);
        Optional<ColumnNameReviser> nameReviser = this.reviseEntry.getColumnNameReviser(this.rule, tableName);
        Optional<ColumnGeneratedReviser> generatedReviser = this.reviseEntry.getColumnGeneratedReviser(this.rule, tableName);
        LinkedList<ColumnMetaData> result = new LinkedList<ColumnMetaData>();
        for (ColumnMetaData each : originalMetaDataList) {
            if (existedReviser.isPresent() && !existedReviser.get().isExisted(each.getName())) continue;
            String name = nameReviser.isPresent() ? nameReviser.get().revise(each.getName()) : each.getName();
            boolean generated = generatedReviser.map(optional -> optional.revise(each)).orElseGet(() -> ((ColumnMetaData)each).isGenerated());
            result.add(new ColumnMetaData(name, each.getDataType(), each.isPrimaryKey(), generated, each.isCaseSensitive(), each.isVisible(), each.isUnsigned(), each.isNullable()));
        }
        return result;
    }

    @Generated
    public ColumnReviseEngine(T rule, MetaDataReviseEntry<T> reviseEntry) {
        this.rule = rule;
        this.reviseEntry = reviseEntry;
    }
}

