/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.kernel;

import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContextBuilder;
import org.apache.shardingsphere.infra.executor.sql.log.SQLLogger;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.rewrite.SQLRewriteEntry;
import org.apache.shardingsphere.infra.rewrite.engine.result.SQLRewriteResult;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.engine.SQLRouteEngine;

public final class KernelProcessor {
    public ExecutionContext generateExecutionContext(LogicSQL logicSQL, ShardingSphereMetaData metaData, ConfigurationProperties props) {
        RouteContext routeContext = this.route(logicSQL, metaData, props);
        SQLRewriteResult rewriteResult = this.rewrite(logicSQL, metaData, props, routeContext);
        ExecutionContext result = this.createExecutionContext(logicSQL, metaData, routeContext, rewriteResult);
        this.logSQL(logicSQL, props, result);
        return result;
    }

    private RouteContext route(LogicSQL logicSQL, ShardingSphereMetaData metaData, ConfigurationProperties props) {
        return new SQLRouteEngine(metaData.getRuleMetaData().getRules(), props).route(logicSQL, metaData);
    }

    private SQLRewriteResult rewrite(LogicSQL logicSQL, ShardingSphereMetaData metaData, ConfigurationProperties props, RouteContext routeContext) {
        SQLRewriteEntry sqlRewriteEntry = new SQLRewriteEntry(metaData.getName(), metaData.getSchema(), props, metaData.getRuleMetaData().getRules());
        return sqlRewriteEntry.rewrite(logicSQL.getSql(), logicSQL.getParameters(), logicSQL.getSqlStatementContext(), routeContext);
    }

    private ExecutionContext createExecutionContext(LogicSQL logicSQL, ShardingSphereMetaData metaData, RouteContext routeContext, SQLRewriteResult rewriteResult) {
        return new ExecutionContext(logicSQL, ExecutionContextBuilder.build((ShardingSphereMetaData)metaData, (SQLRewriteResult)rewriteResult, (SQLStatementContext)logicSQL.getSqlStatementContext()), routeContext);
    }

    private void logSQL(LogicSQL logicSQL, ConfigurationProperties props, ExecutionContext executionContext) {
        if (((Boolean)props.getValue((Enum)ConfigurationPropertyKey.SQL_SHOW)).booleanValue()) {
            SQLLogger.logSQL((LogicSQL)logicSQL, (boolean)((Boolean)props.getValue((Enum)ConfigurationPropertyKey.SQL_SIMPLE)), (ExecutionContext)executionContext);
        }
    }
}

