/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher.type;

import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.event.MetaDataRefreshedEvent;
import org.apache.shardingsphere.infra.metadata.database.schema.event.SchemaAlteredEvent;
import org.apache.shardingsphere.infra.rule.identifier.type.MutableDataNodeRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropTableStatement;

public final class DropTableStatementSchemaRefresher
implements MetaDataRefresher<DropTableStatement> {
    @Override
    public Optional<MetaDataRefreshedEvent> refresh(ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, DropTableStatement sqlStatement, ConfigurationProperties props) {
        SchemaAlteredEvent event = new SchemaAlteredEvent(database.getName(), schemaName);
        sqlStatement.getTables().forEach(each -> {
            database.getSchema(schemaName).removeTable(each.getTableName().getIdentifier().getValue());
            event.getDroppedTables().add(each.getTableName().getIdentifier().getValue());
        });
        Collection rules = database.getRuleMetaData().findRules(MutableDataNodeRule.class);
        for (SimpleTableSegment each2 : sqlStatement.getTables()) {
            this.removeDataNode(rules, each2, schemaName);
        }
        return Optional.of(event);
    }

    private void removeDataNode(Collection<MutableDataNodeRule> rules, SimpleTableSegment tobeRemovedSegment, String schemaName) {
        for (MutableDataNodeRule each : rules) {
            each.remove(schemaName, tobeRemovedSegment.getTableName().getIdentifier().getValue());
        }
    }

    public String getType() {
        return DropTableStatement.class.getName();
    }
}

