/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresherFactory;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.event.MetaDataRefreshedEvent;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class MetaDataRefreshEngine {
    private static final Collection<Class<? extends SQLStatement>> IGNORED_SQL_STATEMENT_CLASSES = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ShardingSphereDatabase database;
    private final ConfigurationProperties props;

    public Optional<MetaDataRefreshedEvent> refresh(SQLStatementContext<?> sqlStatementContext, Collection<RouteUnit> routeUnits) throws SQLException {
        Class<?> sqlStatementClass = sqlStatementContext.getSqlStatement().getClass();
        if (IGNORED_SQL_STATEMENT_CLASSES.contains(sqlStatementClass)) {
            return Optional.empty();
        }
        Optional<MetaDataRefresher> schemaRefresher = MetaDataRefresherFactory.findInstance(sqlStatementClass);
        if (schemaRefresher.isPresent()) {
            String schemaName = sqlStatementContext.getTablesContext().getSchemaName().orElseGet(() -> DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)sqlStatementContext.getDatabaseType(), (String)this.database.getName())).toLowerCase();
            Collection logicDataSourceNames = routeUnits.stream().map(each -> each.getDataSourceMapper().getLogicName()).collect(Collectors.toList());
            return schemaRefresher.get().refresh(this.database, logicDataSourceNames, schemaName, sqlStatementContext.getSqlStatement(), this.props);
        }
        IGNORED_SQL_STATEMENT_CLASSES.add(sqlStatementClass);
        return Optional.empty();
    }

    @Generated
    public MetaDataRefreshEngine(ShardingSphereDatabase database, ConfigurationProperties props) {
        this.database = database;
        this.props = props;
    }
}

