/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher.type;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilder;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterial;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereView;
import org.apache.shardingsphere.infra.metadata.database.schema.event.MetaDataRefreshedEvent;
import org.apache.shardingsphere.infra.metadata.database.schema.event.SchemaAlteredEvent;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.MutableDataNodeRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterViewStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.AlterViewStatementHandler;

public final class AlterViewStatementSchemaRefresher
implements MetaDataRefresher<AlterViewStatement> {
    @Override
    public Optional<MetaDataRefreshedEvent> refresh(ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, AlterViewStatement sqlStatement, ConfigurationProperties props) throws SQLException {
        Optional viewDefinition;
        String viewName = sqlStatement.getView().getTableName().getIdentifier().getValue();
        SchemaAlteredEvent event = new SchemaAlteredEvent(database.getName(), schemaName);
        Optional renameView = AlterViewStatementHandler.getRenameView((AlterViewStatement)sqlStatement);
        if (renameView.isPresent()) {
            String renameViewName = ((SimpleTableSegment)renameView.get()).getTableName().getIdentifier().getValue();
            String originalView = database.getSchema(schemaName).getView(viewName).getViewDefinition();
            this.putTableMetaData(database, logicDataSourceNames, schemaName, renameViewName, originalView, props);
            this.removeTableMetaData(database, schemaName, viewName);
            event.getAlteredTables().add(database.getSchema(schemaName).getTable(renameViewName));
            event.getAlteredViews().add(database.getSchema(schemaName).getView(renameViewName));
            event.getDroppedTables().add(viewName);
            event.getDroppedViews().add(viewName);
        }
        if ((viewDefinition = AlterViewStatementHandler.getViewDefinition((AlterViewStatement)sqlStatement)).isPresent()) {
            this.putTableMetaData(database, logicDataSourceNames, schemaName, viewName, (String)viewDefinition.get(), props);
            event.getAlteredTables().add(database.getSchema(schemaName).getTable(viewName));
            event.getAlteredViews().add(database.getSchema(schemaName).getView(viewName));
        }
        return Optional.of(event);
    }

    private void removeTableMetaData(ShardingSphereDatabase database, String schemaName, String viewName) {
        database.getSchema(schemaName).removeTable(viewName);
        database.getSchema(schemaName).removeView(viewName);
        database.getRuleMetaData().findRules(MutableDataNodeRule.class).forEach(each -> each.remove(schemaName, viewName));
    }

    private void putTableMetaData(ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, String viewName, String viewDefinition, ConfigurationProperties props) throws SQLException {
        if (!this.containsInImmutableDataNodeContainedRule(viewName, database)) {
            database.getRuleMetaData().findRules(MutableDataNodeRule.class).forEach(each -> each.put((String)logicDataSourceNames.iterator().next(), schemaName, viewName));
        }
        GenericSchemaBuilderMaterial material = new GenericSchemaBuilderMaterial(database.getProtocolType(), database.getResourceMetaData().getStorageTypes(), database.getResourceMetaData().getDataSources(), database.getRuleMetaData().getRules(), props, schemaName);
        Map schemaMap = GenericSchemaBuilder.build(Collections.singletonList(viewName), (GenericSchemaBuilderMaterial)material);
        Optional<ShardingSphereTable> actualViewMetaData = Optional.ofNullable((ShardingSphereSchema)schemaMap.get(schemaName)).map(optional -> optional.getTable(viewName));
        actualViewMetaData.ifPresent(optional -> database.getSchema(schemaName).putTable(viewName, optional));
        database.getSchema(schemaName).putView(viewName, new ShardingSphereView(viewName, viewDefinition));
    }

    private boolean containsInImmutableDataNodeContainedRule(String viewName, ShardingSphereDatabase database) {
        return database.getRuleMetaData().findRules(DataNodeContainedRule.class).stream().filter(each -> !(each instanceof MutableDataNodeRule)).anyMatch(each -> each.getAllTables().contains(viewName));
    }

    public String getType() {
        return AlterViewStatement.class.getName();
    }
}

