/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.kernel.impl;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.kernel.impl.ShardingSphereThreadFactoryBuilder;

public final class ShardingSphereExecutorService {
    private static final String DEFAULT_NAME_FORMAT = "%d";
    private static final ExecutorService SHUTDOWN_EXECUTOR = Executors.newSingleThreadExecutor(ShardingSphereThreadFactoryBuilder.build("Executor-Engine-Closer"));
    private final ListeningExecutorService executorService;

    public ShardingSphereExecutorService(int executorSize) {
        this(executorSize, DEFAULT_NAME_FORMAT);
    }

    public ShardingSphereExecutorService(int executorSize, String nameFormat) {
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)this.getExecutorService(executorSize, nameFormat));
        MoreExecutors.addDelayedShutdownHook((ExecutorService)this.executorService, (long)60L, (TimeUnit)TimeUnit.SECONDS);
    }

    private ExecutorService getExecutorService(int executorSize, String nameFormat) {
        ThreadFactory threadFactory = ShardingSphereThreadFactoryBuilder.build(nameFormat);
        return 0 == executorSize ? Executors.newCachedThreadPool(threadFactory) : Executors.newFixedThreadPool(executorSize, threadFactory);
    }

    public void close() {
        SHUTDOWN_EXECUTOR.execute(() -> {
            try {
                this.executorService.shutdown();
                while (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        });
    }

    @Generated
    public ListeningExecutorService getExecutorService() {
        return this.executorService;
    }
}

