/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.group;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.infra.executor.kernel.InputGroup;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.context.SQLUnit;
import org.apache.shardingsphere.infra.executor.sql.group.ExecuteGroupDecorator;
import org.apache.shardingsphere.infra.executor.sql.group.ExecuteGroupEngine;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.ordered.OrderedSPIRegistry;

public abstract class AbstractExecuteGroupEngine<T>
implements ExecuteGroupEngine<T> {
    private final Map<ShardingSphereRule, ExecuteGroupDecorator> decorators;

    protected AbstractExecuteGroupEngine(Collection<ShardingSphereRule> rules) {
        this.decorators = OrderedSPIRegistry.getRegisteredServices(rules, ExecuteGroupDecorator.class);
    }

    @Override
    public final Collection<InputGroup<T>> generate(RouteContext routeContext, Collection<ExecutionUnit> executionUnits) throws SQLException {
        LinkedList<InputGroup<T>> result = new LinkedList<InputGroup<T>>();
        for (Map.Entry<String, List<SQLUnit>> entry : this.aggregateSQLUnitGroups(executionUnits).entrySet()) {
            result.addAll(this.generateSQLExecuteGroups(entry.getKey(), entry.getValue()));
        }
        return this.decorate(routeContext, result);
    }

    private Map<String, List<SQLUnit>> aggregateSQLUnitGroups(Collection<ExecutionUnit> executionUnits) {
        LinkedHashMap<String, List<SQLUnit>> result = new LinkedHashMap<String, List<SQLUnit>>(executionUnits.size(), 1.0f);
        for (ExecutionUnit each : executionUnits) {
            if (!result.containsKey(each.getDataSourceName())) {
                result.put(each.getDataSourceName(), new LinkedList());
            }
            ((List)result.get(each.getDataSourceName())).add(each.getSqlUnit());
        }
        return result;
    }

    protected abstract List<InputGroup<T>> generateSQLExecuteGroups(String var1, List<SQLUnit> var2) throws SQLException;

    private Collection<InputGroup<T>> decorate(RouteContext routeContext, Collection<InputGroup<T>> inputGroups) {
        Collection<InputGroup<T>> result = inputGroups;
        for (Map.Entry<ShardingSphereRule, ExecuteGroupDecorator> each : this.decorators.entrySet()) {
            result = each.getValue().decorate(routeContext, each.getKey(), result);
        }
        return result;
    }

    static {
        ShardingSphereServiceLoader.register(ExecuteGroupDecorator.class);
    }
}

