/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.raw.execute;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorKernel;
import org.apache.shardingsphere.infra.executor.kernel.InputGroup;
import org.apache.shardingsphere.infra.executor.sql.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.raw.RawSQLExecuteUnit;
import org.apache.shardingsphere.infra.executor.sql.raw.execute.callback.RawSQLExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.raw.execute.result.query.ExecuteQueryResult;
import org.apache.shardingsphere.infra.executor.sql.raw.execute.result.update.ExecuteUpdateResult;
import org.apache.shardingsphere.infra.executor.sql.resourced.jdbc.executor.ExecutorExceptionHandler;

public final class RawJDBCExecutor {
    private final ExecutorKernel executorKernel;
    private final boolean serial;

    public List<QueryResult> executeQuery(Collection<InputGroup<RawSQLExecuteUnit>> inputGroups, RawSQLExecutorCallback callback) throws SQLException {
        return this.doExecute(inputGroups, callback).stream().map(each -> ((ExecuteQueryResult)each).getQueryResult()).collect(Collectors.toList());
    }

    public int executeUpdate(Collection<InputGroup<RawSQLExecuteUnit>> inputGroups, RawSQLExecutorCallback callback) throws SQLException {
        List<Integer> results = this.doExecute(inputGroups, callback).stream().map(each -> ((ExecuteUpdateResult)each).getUpdateCount()).collect(Collectors.toList());
        return this.accumulate(results);
    }

    private int accumulate(List<Integer> results) {
        int result = 0;
        for (Integer each : results) {
            result += null == each ? 0 : each;
        }
        return result;
    }

    public boolean execute(Collection<InputGroup<RawSQLExecuteUnit>> inputGroups, RawSQLExecutorCallback callback) throws SQLException {
        List results = this.doExecute(inputGroups, callback);
        if (null == results || results.isEmpty() || null == results.get(0)) {
            return false;
        }
        return results.get(0) instanceof ExecuteQueryResult;
    }

    private <T> List<T> doExecute(Collection<InputGroup<RawSQLExecuteUnit>> inputGroups, RawSQLExecutorCallback callback) throws SQLException {
        try {
            return this.executorKernel.execute(inputGroups, null, callback, this.serial);
        }
        catch (SQLException ex) {
            ExecutorExceptionHandler.handleException(ex);
            return Collections.emptyList();
        }
    }

    @Generated
    public RawJDBCExecutor(ExecutorKernel executorKernel, boolean serial) {
        this.executorKernel = executorKernel;
        this.serial = serial;
    }
}

