/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.raw.group;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.infra.executor.kernel.InputGroup;
import org.apache.shardingsphere.infra.executor.sql.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.context.SQLUnit;
import org.apache.shardingsphere.infra.executor.sql.group.AbstractExecuteGroupEngine;
import org.apache.shardingsphere.infra.executor.sql.raw.RawSQLExecuteUnit;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class RawExecuteGroupEngine
extends AbstractExecuteGroupEngine<RawSQLExecuteUnit> {
    private final int maxConnectionsSizePerQuery;

    public RawExecuteGroupEngine(int maxConnectionsSizePerQuery, Collection<ShardingSphereRule> rules) {
        super(rules);
        this.maxConnectionsSizePerQuery = maxConnectionsSizePerQuery;
    }

    @Override
    protected List<InputGroup<RawSQLExecuteUnit>> generateSQLExecuteGroups(String dataSourceName, List<SQLUnit> sqlUnits) {
        LinkedList<InputGroup<RawSQLExecuteUnit>> result = new LinkedList<InputGroup<RawSQLExecuteUnit>>();
        int desiredPartitionSize = Math.max(0 == sqlUnits.size() % this.maxConnectionsSizePerQuery ? sqlUnits.size() / this.maxConnectionsSizePerQuery : sqlUnits.size() / this.maxConnectionsSizePerQuery + 1, 1);
        List sqlUnitPartitions = Lists.partition(sqlUnits, (int)desiredPartitionSize);
        ConnectionMode connectionMode = this.maxConnectionsSizePerQuery < sqlUnits.size() ? ConnectionMode.CONNECTION_STRICTLY : ConnectionMode.MEMORY_STRICTLY;
        for (List each : sqlUnitPartitions) {
            result.add(this.generateSQLExecuteGroup(dataSourceName, each, connectionMode));
        }
        return result;
    }

    private InputGroup<RawSQLExecuteUnit> generateSQLExecuteGroup(String dataSourceName, List<SQLUnit> sqlUnitGroup, ConnectionMode connectionMode) {
        LinkedList<RawSQLExecuteUnit> rawSQLExecuteUnits = new LinkedList<RawSQLExecuteUnit>();
        for (SQLUnit each : sqlUnitGroup) {
            rawSQLExecuteUnits.add(new RawSQLExecuteUnit(new ExecutionUnit(dataSourceName, each), connectionMode));
        }
        return new InputGroup<RawSQLExecuteUnit>(rawSQLExecuteUnits);
    }
}

