/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.resourced.group;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.infra.executor.kernel.InputGroup;
import org.apache.shardingsphere.infra.executor.sql.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.context.SQLUnit;
import org.apache.shardingsphere.infra.executor.sql.group.AbstractExecuteGroupEngine;
import org.apache.shardingsphere.infra.executor.sql.resourced.ExecutionConnection;
import org.apache.shardingsphere.infra.executor.sql.resourced.ResourceManagedExecuteUnit;
import org.apache.shardingsphere.infra.executor.sql.resourced.StorageResourceOption;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public abstract class ResourceManagedExecuteGroupEngine<U extends ResourceManagedExecuteUnit, E extends ExecutionConnection<C, ?, O>, C, O extends StorageResourceOption>
extends AbstractExecuteGroupEngine<U> {
    private final int maxConnectionsSizePerQuery;
    private final E executionConnection;
    private final O option;

    protected ResourceManagedExecuteGroupEngine(int maxConnectionsSizePerQuery, E executionConnection, O option, Collection<ShardingSphereRule> rules) {
        super(rules);
        this.maxConnectionsSizePerQuery = maxConnectionsSizePerQuery;
        this.executionConnection = executionConnection;
        this.option = option;
    }

    @Override
    protected final List<InputGroup<U>> generateSQLExecuteGroups(String dataSourceName, List<SQLUnit> sqlUnits) throws SQLException {
        LinkedList<InputGroup<U>> result = new LinkedList<InputGroup<U>>();
        int desiredPartitionSize = Math.max(0 == sqlUnits.size() % this.maxConnectionsSizePerQuery ? sqlUnits.size() / this.maxConnectionsSizePerQuery : sqlUnits.size() / this.maxConnectionsSizePerQuery + 1, 1);
        List sqlUnitPartitions = Lists.partition(sqlUnits, (int)desiredPartitionSize);
        ConnectionMode connectionMode = this.maxConnectionsSizePerQuery < sqlUnits.size() ? ConnectionMode.CONNECTION_STRICTLY : ConnectionMode.MEMORY_STRICTLY;
        List connections = this.executionConnection.getConnections(dataSourceName, sqlUnitPartitions.size(), connectionMode);
        int count = 0;
        for (List each : sqlUnitPartitions) {
            result.add(this.generateSQLExecuteGroup(dataSourceName, each, connections.get(count++), connectionMode));
        }
        return result;
    }

    private InputGroup<U> generateSQLExecuteGroup(String dataSourceName, List<SQLUnit> sqlUnitGroup, C connection, ConnectionMode connectionMode) throws SQLException {
        LinkedList<U> result = new LinkedList<U>();
        for (SQLUnit each : sqlUnitGroup) {
            result.add(this.createStorageResourceExecuteUnit(new ExecutionUnit(dataSourceName, each), this.executionConnection, connection, connectionMode, this.option));
        }
        return new InputGroup(result);
    }

    protected abstract U createStorageResourceExecuteUnit(ExecutionUnit var1, E var2, C var3, ConnectionMode var4, O var5) throws SQLException;
}

