/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.resourced.jdbc.executor;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorKernel;
import org.apache.shardingsphere.infra.executor.kernel.InputGroup;
import org.apache.shardingsphere.infra.executor.sql.resourced.jdbc.StatementExecuteUnit;
import org.apache.shardingsphere.infra.executor.sql.resourced.jdbc.executor.ExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.resourced.jdbc.executor.SQLExecutorCallback;

public final class SQLExecutor {
    private final ExecutorKernel executorKernel;
    private final boolean serial;

    public <T> List<T> execute(Collection<InputGroup<StatementExecuteUnit>> inputGroups, SQLExecutorCallback<T> callback) throws SQLException {
        return this.execute(inputGroups, null, callback);
    }

    public <T> List<T> execute(Collection<InputGroup<StatementExecuteUnit>> inputGroups, SQLExecutorCallback<T> firstCallback, SQLExecutorCallback<T> callback) throws SQLException {
        try {
            return this.executorKernel.execute(inputGroups, firstCallback, callback, this.serial);
        }
        catch (SQLException ex) {
            ExecutorExceptionHandler.handleException(ex);
            return Collections.emptyList();
        }
    }

    @Generated
    public SQLExecutor(ExecutorKernel executorKernel, boolean serial) {
        this.executorKernel = executorKernel;
        this.serial = serial;
    }
}

