/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.execute.engine.raw;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorEngine;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawSQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.callback.RawSQLExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.update.UpdateResult;
import org.apache.shardingsphere.infra.executor.sql.process.ExecuteProcessEngine;

public final class RawExecutor {
    private final ExecutorEngine executorEngine;
    private final boolean serial;
    private final ConfigurationProperties props;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ExecuteResult> execute(ExecutionGroupContext<RawSQLExecutionUnit> executionGroupContext, SQLStatementContext<?> sqlStatementContext, RawSQLExecutorCallback callback) throws SQLException {
        try {
            ExecuteProcessEngine.initialize(sqlStatementContext, executionGroupContext, this.props);
            List<ExecuteResult> results = this.execute(executionGroupContext, (RawSQLExecutorCallback)null, callback);
            ExecuteProcessEngine.finish(executionGroupContext.getExecutionID());
            if (null == results || results.isEmpty() || null == results.get(0)) {
                Set<ExecuteResult> set = Collections.singleton(new UpdateResult(0, 0L));
                return set;
            }
            List<ExecuteResult> list = results;
            return list;
        }
        finally {
            ExecuteProcessEngine.clean();
        }
    }

    private <T> List<T> execute(ExecutionGroupContext<RawSQLExecutionUnit> executionGroupContext, RawSQLExecutorCallback firstCallback, RawSQLExecutorCallback callback) throws SQLException {
        try {
            return this.executorEngine.execute(executionGroupContext, firstCallback, callback, this.serial);
        }
        catch (SQLException ex) {
            SQLExecutorExceptionHandler.handleException(ex);
            return Collections.emptyList();
        }
    }

    @Generated
    public RawExecutor(ExecutorEngine executorEngine, boolean serial, ConfigurationProperties props) {
        this.executorEngine = executorEngine;
        this.serial = serial;
        this.props = props;
    }
}

