/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.federate.schema.table.generator;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.context.SQLUnit;
import org.apache.shardingsphere.infra.executor.sql.federate.schema.table.generator.FederateExecutionSQLGenerator;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;

public final class FederateExecutionContextGenerator {
    private final String table;
    private final ExecutionContext routeExecutionContext;
    private final FederateExecutionSQLGenerator generator;

    public ExecutionContext generate() {
        RouteContext routeContext = this.getRouteContext(this.routeExecutionContext.getRouteContext());
        return new ExecutionContext(this.routeExecutionContext.getSqlStatementContext(), this.getExecutionUnits(routeContext.getRouteUnits(), this.generator), routeContext);
    }

    private Collection<ExecutionUnit> getExecutionUnits(Collection<RouteUnit> routeUnits, FederateExecutionSQLGenerator generator) {
        LinkedHashSet<ExecutionUnit> result = new LinkedHashSet<ExecutionUnit>();
        for (RouteUnit each : routeUnits) {
            this.fillExecutionUnits(result, generator, each);
        }
        return result;
    }

    private void fillExecutionUnits(Collection<ExecutionUnit> executionUnits, FederateExecutionSQLGenerator generator, RouteUnit routeUnit) {
        for (RouteMapper mapper : routeUnit.getTableMappers()) {
            if (!mapper.getLogicName().equals(this.table)) continue;
            executionUnits.add(new ExecutionUnit(routeUnit.getDataSourceMapper().getActualName(), new SQLUnit(generator.generate(mapper.getActualName()), Collections.emptyList(), Collections.singletonList(mapper))));
        }
    }

    private RouteContext getRouteContext(RouteContext routeContext) {
        RouteContext result = new RouteContext();
        result.getRouteUnits().addAll(this.getRouteUnits(routeContext));
        return result;
    }

    private Collection<RouteUnit> getRouteUnits(RouteContext routeContext) {
        LinkedHashSet<RouteUnit> result = new LinkedHashSet<RouteUnit>(routeContext.getRouteUnits().size(), 1.0f);
        for (RouteUnit each : routeContext.getRouteUnits()) {
            RouteUnit routeUnit = this.getRouteUnit(each);
            if (routeUnit.getTableMappers().isEmpty()) continue;
            result.add(routeUnit);
        }
        return result;
    }

    private RouteUnit getRouteUnit(RouteUnit routeUnit) {
        RouteUnit result = new RouteUnit(routeUnit.getDataSourceMapper(), new LinkedHashSet(routeUnit.getTableMappers().size(), 1.0f));
        for (RouteMapper each : routeUnit.getTableMappers()) {
            if (!each.getLogicName().equals(this.table)) continue;
            result.getTableMappers().add(each);
        }
        return result;
    }

    @Generated
    public FederateExecutionContextGenerator(String table, ExecutionContext routeExecutionContext, FederateExecutionSQLGenerator generator) {
        this.table = table;
        this.routeExecutionContext = routeExecutionContext;
        this.generator = generator;
    }
}

