/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.process.model;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.process.model.ExecuteProcessConstants;
import org.apache.shardingsphere.infra.executor.sql.process.model.ExecuteProcessUnit;

public final class ExecuteProcessContext {
    private final String executionID;
    private final Collection<ExecuteProcessUnit> unitStatuses;
    private final long startTimeMillis = System.currentTimeMillis();

    public ExecuteProcessContext(ExecutionGroupContext<? extends SQLExecutionUnit> executionGroupContext, ExecuteProcessConstants constants) {
        this.executionID = executionGroupContext.getExecutionID();
        this.unitStatuses = this.createExecutionUnitStatuses(executionGroupContext, constants);
    }

    private Collection<ExecuteProcessUnit> createExecutionUnitStatuses(ExecutionGroupContext<? extends SQLExecutionUnit> executionGroupContext, ExecuteProcessConstants constants) {
        LinkedList<ExecuteProcessUnit> result = new LinkedList<ExecuteProcessUnit>();
        for (ExecutionGroup<? extends SQLExecutionUnit> group : executionGroupContext.getInputGroups()) {
            for (SQLExecutionUnit sQLExecutionUnit : group.getInputs()) {
                result.add(new ExecuteProcessUnit(sQLExecutionUnit.getExecutionUnit(), constants));
            }
        }
        return result;
    }

    @Generated
    public String getExecutionID() {
        return this.executionID;
    }

    @Generated
    public Collection<ExecuteProcessUnit> getUnitStatuses() {
        return this.unitStatuses;
    }

    @Generated
    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }
}

