/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.federate.original;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.schema.Schema;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.context.SQLUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.stream.JDBCStreamQueryResult;
import org.apache.shardingsphere.infra.executor.sql.federate.FederationExecutor;
import org.apache.shardingsphere.infra.executor.sql.federate.original.FilterableSchema;
import org.apache.shardingsphere.infra.executor.sql.federate.original.table.FilterableTableScanExecutor;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.optimize.context.OptimizerContext;
import org.apache.shardingsphere.infra.optimize.context.parser.OptimizerParserContext;
import org.apache.shardingsphere.infra.optimize.metadata.FederationSchemaMetaData;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;

public final class OriginalFilterableExecutor
implements FederationExecutor {
    public static final String CONNECTION_URL = "jdbc:calcite:";
    public static final String DRIVER_NAME = "org.apache.calcite.jdbc.Driver";
    private final String schemaName;
    private final OptimizerContext optimizerContext;
    private final ConfigurationProperties props;
    private final JDBCExecutor jdbcExecutor;
    private Statement statement;

    @Override
    public List<QueryResult> executeQuery(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> callback, ExecutionContext executionContext) throws SQLException {
        ResultSet resultSet = this.execute(prepareEngine, callback, executionContext);
        return Collections.singletonList(new JDBCStreamQueryResult(resultSet));
    }

    private ResultSet execute(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> callback, ExecutionContext executionContext) throws SQLException {
        SQLUnit sqlUnit = executionContext.getExecutionUnits().iterator().next().getSqlUnit();
        PreparedStatement preparedStatement = this.createConnection(prepareEngine, callback, executionContext).prepareStatement(SQLUtil.trimSemicolon((String)sqlUnit.getSql()));
        this.setParameters(preparedStatement, sqlUnit.getParameters());
        this.statement = preparedStatement;
        return preparedStatement.executeQuery();
    }

    private Connection createConnection(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> callback, ExecutionContext executionContext) throws SQLException {
        Connection result = DriverManager.getConnection(CONNECTION_URL, ((OptimizerParserContext)this.optimizerContext.getParserContexts().get(this.schemaName)).getDialectProps());
        this.addSchema(result.unwrap(CalciteConnection.class), prepareEngine, callback, executionContext);
        return result;
    }

    private void addSchema(CalciteConnection connection, DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> callback, ExecutionContext executionContext) throws SQLException {
        FilterableTableScanExecutor executor = new FilterableTableScanExecutor(prepareEngine, this.jdbcExecutor, callback, this.props, executionContext, ((OptimizerParserContext)this.optimizerContext.getParserContexts().get(this.schemaName)).getDatabaseType().getQuoteCharacter());
        FilterableSchema schema = new FilterableSchema((FederationSchemaMetaData)this.optimizerContext.getMetaData().getSchemas().get(this.schemaName), executor);
        connection.getRootSchema().add(this.schemaName, (Schema)schema);
        connection.setSchema(this.schemaName);
    }

    private void setParameters(PreparedStatement preparedStatement, List<Object> parameters) throws SQLException {
        int count = 1;
        for (Object each : parameters) {
            preparedStatement.setObject(count, each);
            ++count;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.statement.getResultSet();
    }

    @Override
    public void close() throws SQLException {
        if (null != this.statement && !this.statement.isClosed()) {
            Connection connection = this.statement.getConnection();
            this.statement.close();
            connection.close();
        }
    }

    @Generated
    public OriginalFilterableExecutor(String schemaName, OptimizerContext optimizerContext, ConfigurationProperties props, JDBCExecutor jdbcExecutor) {
        this.schemaName = schemaName;
        this.optimizerContext = optimizerContext;
        this.props = props;
        this.jdbcExecutor = jdbcExecutor;
    }

    static {
        try {
            Class.forName(DRIVER_NAME);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }
}

