/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.federate.original.sql;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;

public final class RouteContextFilter {
    public RouteContext filter(String toBeKeptTableName, RouteContext routeContext) {
        RouteContext result = new RouteContext();
        result.getRouteUnits().addAll(this.filterRouteUnits(toBeKeptTableName, routeContext));
        return result;
    }

    private Collection<RouteUnit> filterRouteUnits(String toBeKeptTableName, RouteContext routeContext) {
        return routeContext.getRouteUnits().stream().map(each -> this.filterRouteUnit(toBeKeptTableName, (RouteUnit)each)).filter(each -> !each.getTableMappers().isEmpty()).collect(Collectors.toList());
    }

    private RouteUnit filterRouteUnit(String toBeKeptTableName, RouteUnit routeUnit) {
        return new RouteUnit(routeUnit.getDataSourceMapper(), this.filterTableMappers(toBeKeptTableName, routeUnit));
    }

    private List<RouteMapper> filterTableMappers(String toBeKeptTableName, RouteUnit routeUnit) {
        return routeUnit.getTableMappers().stream().filter(each -> each.getLogicName().equalsIgnoreCase(toBeKeptTableName)).collect(Collectors.toList());
    }
}

