/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.federate.original.table;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.federate.original.sql.FilterableExecutionContextGenerator;
import org.apache.shardingsphere.infra.executor.sql.federate.original.table.FilterableTableScanContext;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.process.ExecuteProcessEngine;
import org.apache.shardingsphere.infra.optimize.metadata.FederationTableMetaData;
import org.apache.shardingsphere.sql.parser.sql.common.constant.QuoteCharacter;

public final class FilterableTableScanExecutor {
    private final DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine;
    private final JDBCExecutor jdbcExecutor;
    private final JDBCExecutorCallback<? extends ExecuteResult> callback;
    private final ConfigurationProperties props;
    private final FilterableExecutionContextGenerator executionContextGenerator;

    public FilterableTableScanExecutor(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutor jdbcExecutor, JDBCExecutorCallback<? extends ExecuteResult> callback, ConfigurationProperties props, ExecutionContext routeExecutionContext, QuoteCharacter quoteCharacter) {
        this.jdbcExecutor = jdbcExecutor;
        this.callback = callback;
        this.prepareEngine = prepareEngine;
        this.props = props;
        this.executionContextGenerator = new FilterableExecutionContextGenerator(routeExecutionContext, quoteCharacter);
    }

    public Collection<QueryResult> execute(FederationTableMetaData tableMetaData, FilterableTableScanContext scanContext) {
        ExecutionContext context = this.executionContextGenerator.generate(tableMetaData, scanContext);
        try {
            ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext = this.prepareEngine.prepare(context.getRouteContext(), context.getExecutionUnits());
            ExecuteProcessEngine.initialize(context.getLogicSQL(), executionGroupContext, this.props);
            Collection result = this.jdbcExecutor.execute(executionGroupContext, this.callback).stream().map(each -> (QueryResult)each).collect(Collectors.toList());
            ExecuteProcessEngine.finish(executionGroupContext.getExecutionID());
            Collection collection = result;
            return collection;
        }
        catch (SQLException ex) {
            throw new ShardingSphereException((Exception)ex);
        }
        finally {
            ExecuteProcessEngine.clean();
        }
    }
}

