/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.prepare;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupReportContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.context.SQLUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.prepare.ExecutionPrepareDecorator;
import org.apache.shardingsphere.infra.executor.sql.prepare.ExecutionPrepareEngine;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.util.spi.type.ordered.OrderedSPILoader;

public abstract class AbstractExecutionPrepareEngine<T>
implements ExecutionPrepareEngine<T> {
    private final int maxConnectionsSizePerQuery;
    private final Map<ShardingSphereRule, ExecutionPrepareDecorator> decorators;

    protected AbstractExecutionPrepareEngine(int maxConnectionsSizePerQuery, Collection<ShardingSphereRule> rules) {
        this.maxConnectionsSizePerQuery = maxConnectionsSizePerQuery;
        this.decorators = OrderedSPILoader.getServices(ExecutionPrepareDecorator.class, rules);
    }

    @Override
    public final ExecutionGroupContext<T> prepare(RouteContext routeContext, Collection<ExecutionUnit> executionUnits, ExecutionGroupReportContext reportContext) throws SQLException {
        LinkedList<ExecutionGroup<T>> result = new LinkedList<ExecutionGroup<T>>();
        for (Map.Entry<String, List<SQLUnit>> entry : this.aggregateSQLUnitGroups(executionUnits).entrySet()) {
            String dataSourceName = entry.getKey();
            List<SQLUnit> sqlUnits = entry.getValue();
            List<List<SQLUnit>> sqlUnitGroups = this.group(sqlUnits);
            ConnectionMode connectionMode = this.maxConnectionsSizePerQuery < sqlUnits.size() ? ConnectionMode.CONNECTION_STRICTLY : ConnectionMode.MEMORY_STRICTLY;
            result.addAll(this.group(dataSourceName, sqlUnitGroups, connectionMode));
        }
        return this.decorate(routeContext, result, reportContext);
    }

    private List<List<SQLUnit>> group(List<SQLUnit> sqlUnits) {
        int desiredPartitionSize = Math.max(0 == sqlUnits.size() % this.maxConnectionsSizePerQuery ? sqlUnits.size() / this.maxConnectionsSizePerQuery : sqlUnits.size() / this.maxConnectionsSizePerQuery + 1, 1);
        return Lists.partition(sqlUnits, (int)desiredPartitionSize);
    }

    protected abstract List<ExecutionGroup<T>> group(String var1, List<List<SQLUnit>> var2, ConnectionMode var3) throws SQLException;

    private Map<String, List<SQLUnit>> aggregateSQLUnitGroups(Collection<ExecutionUnit> executionUnits) {
        LinkedHashMap<String, List<SQLUnit>> result = new LinkedHashMap<String, List<SQLUnit>>(executionUnits.size(), 1.0f);
        for (ExecutionUnit each : executionUnits) {
            if (!result.containsKey(each.getDataSourceName())) {
                result.put(each.getDataSourceName(), new LinkedList());
            }
            ((List)result.get(each.getDataSourceName())).add(each.getSqlUnit());
        }
        return result;
    }

    private ExecutionGroupContext<T> decorate(RouteContext routeContext, Collection<ExecutionGroup<T>> executionGroups, ExecutionGroupReportContext reportContext) {
        Collection<ExecutionGroup<T>> result = executionGroups;
        for (Map.Entry<ShardingSphereRule, ExecutionPrepareDecorator> each : this.decorators.entrySet()) {
            result = each.getValue().decorate(routeContext, each.getKey(), result);
        }
        return new ExecutionGroupContext<T>(result, reportContext);
    }
}

