/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.process;

import java.util.Optional;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.process.ShowProcessListManager;
import org.apache.shardingsphere.infra.executor.sql.process.model.ExecuteProcessContext;
import org.apache.shardingsphere.infra.executor.sql.process.model.ExecuteProcessStatusEnum;
import org.apache.shardingsphere.infra.executor.sql.process.model.ExecuteProcessUnit;

public final class ExecuteProcessReporter {
    public void report(ExecutionGroupContext<? extends SQLExecutionUnit> executionGroupContext) {
        ExecuteProcessContext executeProcessContext = new ExecuteProcessContext("", executionGroupContext, ExecuteProcessStatusEnum.SLEEP, true);
        ShowProcessListManager.getInstance().putProcessContext(executeProcessContext.getExecutionID(), executeProcessContext);
    }

    public void report(QueryContext queryContext, ExecutionGroupContext<? extends SQLExecutionUnit> executionGroupContext, ExecuteProcessStatusEnum processStatus) {
        ExecuteProcessContext originExecuteProcessContext = ShowProcessListManager.getInstance().getProcessContext(executionGroupContext.getReportContext().getExecutionID());
        boolean isProxyContext = null != originExecuteProcessContext && originExecuteProcessContext.isProxyContext();
        ExecuteProcessContext executeProcessContext = new ExecuteProcessContext(queryContext.getSql(), executionGroupContext, processStatus, isProxyContext);
        ShowProcessListManager.getInstance().putProcessContext(executeProcessContext.getExecutionID(), executeProcessContext);
        ShowProcessListManager.getInstance().putProcessStatement(executeProcessContext.getExecutionID(), executeProcessContext.getProcessStatements());
    }

    public void report(String executionID, SQLExecutionUnit executionUnit, ExecuteProcessStatusEnum processStatus) {
        ExecuteProcessUnit executeProcessUnit = new ExecuteProcessUnit(executionUnit.getExecutionUnit(), processStatus);
        ExecuteProcessContext executeProcessContext = ShowProcessListManager.getInstance().getProcessContext(executionID);
        Optional.ofNullable(executeProcessContext.getProcessUnits().get(executeProcessUnit.getUnitID())).ifPresent(optional -> optional.setProcessStatus(executeProcessUnit.getProcessStatus()));
    }

    public void reportClean(String executionID) {
        ShowProcessListManager.getInstance().removeProcessStatement(executionID);
        ExecuteProcessContext executeProcessContext = ShowProcessListManager.getInstance().getProcessContext(executionID);
        if (null == executeProcessContext) {
            return;
        }
        if (executeProcessContext.isProxyContext()) {
            executeProcessContext.resetExecuteProcessContextToSleep();
        } else {
            ShowProcessListManager.getInstance().removeProcessContext(executionID);
        }
    }

    public void reportRemove(String executionID) {
        ShowProcessListManager.getInstance().removeProcessStatement(executionID);
        ShowProcessListManager.getInstance().removeProcessContext(executionID);
    }
}

