/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.kernel.model;

import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.user.Grantee;

public final class ExecutionGroupReportContext {
    private final String processId;
    private final String databaseName;
    private final Grantee grantee;

    public ExecutionGroupReportContext(String databaseName) {
        this(databaseName, new Grantee("", ""));
    }

    public ExecutionGroupReportContext(String databaseName, Grantee grantee) {
        this(new UUID(ThreadLocalRandom.current().nextLong(), ThreadLocalRandom.current().nextLong()).toString().replace("-", ""), databaseName, grantee);
    }

    @Generated
    public ExecutionGroupReportContext(String processId, String databaseName, Grantee grantee) {
        this.processId = processId;
        this.databaseName = databaseName;
        this.grantee = grantee;
    }

    @Generated
    public String getProcessId() {
        return this.processId;
    }

    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Generated
    public Grantee getGrantee() {
        return this.grantee;
    }
}

