/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.prepare.raw;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.context.SQLUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawSQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.prepare.AbstractExecutionPrepareEngine;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class RawExecutionPrepareEngine
extends AbstractExecutionPrepareEngine<RawSQLExecutionUnit> {
    public RawExecutionPrepareEngine(int maxConnectionsSizePerQuery, Collection<ShardingSphereRule> rules) {
        super(maxConnectionsSizePerQuery, rules);
    }

    @Override
    protected List<ExecutionGroup<RawSQLExecutionUnit>> group(String dataSourceName, int connectionOffset, List<List<SQLUnit>> sqlUnitGroups, ConnectionMode connectionMode) throws SQLException {
        return sqlUnitGroups.stream().map(each -> this.createExecutionGroup(dataSourceName, (List<SQLUnit>)each, connectionMode)).collect(Collectors.toList());
    }

    private ExecutionGroup<RawSQLExecutionUnit> createExecutionGroup(String dataSourceName, List<SQLUnit> sqlUnitGroup, ConnectionMode connectionMode) {
        return new ExecutionGroup<RawSQLExecutionUnit>(sqlUnitGroup.stream().map(each -> new RawSQLExecutionUnit(new ExecutionUnit(dataSourceName, (SQLUnit)each), connectionMode)).collect(Collectors.toList()));
    }
}

