/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.context.SQLUnit;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rewrite.engine.result.GenericSQLRewriteResult;
import org.apache.shardingsphere.infra.rewrite.engine.result.RouteSQLRewriteResult;
import org.apache.shardingsphere.infra.rewrite.engine.result.SQLRewriteResult;
import org.apache.shardingsphere.infra.rewrite.engine.result.SQLRewriteUnit;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;

public final class ExecutionContextBuilder {
    public static Collection<ExecutionUnit> build(ShardingSphereDatabase database, SQLRewriteResult sqlRewriteResult, SQLStatementContext sqlStatementContext) {
        return sqlRewriteResult instanceof GenericSQLRewriteResult ? ExecutionContextBuilder.build(database, (GenericSQLRewriteResult)sqlRewriteResult, sqlStatementContext) : ExecutionContextBuilder.build((RouteSQLRewriteResult)sqlRewriteResult);
    }

    private static Collection<ExecutionUnit> build(ShardingSphereDatabase database, GenericSQLRewriteResult sqlRewriteResult, SQLStatementContext sqlStatementContext) {
        Collection instanceDataSourceNames = database.getResourceMetaData().getAllInstanceDataSourceNames();
        if (instanceDataSourceNames.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new ExecutionUnit((String)instanceDataSourceNames.iterator().next(), new SQLUnit(sqlRewriteResult.getSqlRewriteUnit().getSql(), sqlRewriteResult.getSqlRewriteUnit().getParameters(), ExecutionContextBuilder.getGenericTableRouteMappers(sqlStatementContext))));
    }

    private static Collection<ExecutionUnit> build(RouteSQLRewriteResult sqlRewriteResult) {
        LinkedHashSet<ExecutionUnit> result = new LinkedHashSet<ExecutionUnit>(sqlRewriteResult.getSqlRewriteUnits().size(), 1.0f);
        for (Map.Entry entry : sqlRewriteResult.getSqlRewriteUnits().entrySet()) {
            result.add(new ExecutionUnit(((RouteUnit)entry.getKey()).getDataSourceMapper().getActualName(), new SQLUnit(((SQLRewriteUnit)entry.getValue()).getSql(), ((SQLRewriteUnit)entry.getValue()).getParameters(), ExecutionContextBuilder.getRouteTableRouteMappers(((RouteUnit)entry.getKey()).getTableMappers()))));
        }
        return result;
    }

    private static List<RouteMapper> getRouteTableRouteMappers(Collection<RouteMapper> tableMappers) {
        if (null == tableMappers) {
            return Collections.emptyList();
        }
        ArrayList<RouteMapper> result = new ArrayList<RouteMapper>(tableMappers.size());
        for (RouteMapper each : tableMappers) {
            result.add(new RouteMapper(each.getLogicName(), each.getActualName()));
        }
        return result;
    }

    private static List<RouteMapper> getGenericTableRouteMappers(SQLStatementContext sqlStatementContext) {
        TablesContext tablesContext = null;
        if (null != sqlStatementContext) {
            tablesContext = sqlStatementContext.getTablesContext();
        }
        return null == tablesContext ? Collections.emptyList() : tablesContext.getTableNames().stream().map(each -> new RouteMapper(each, each)).collect(Collectors.toList());
    }

    @Generated
    private ExecutionContextBuilder() {
    }
}

