/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.executor.advanced;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.EnumerableInterpretable;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.runtime.Bindable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.federation.executor.FederationContext;
import org.apache.shardingsphere.infra.federation.executor.FederationExecutor;
import org.apache.shardingsphere.infra.federation.executor.advanced.resultset.FederationResultSet;
import org.apache.shardingsphere.infra.federation.executor.advanced.table.TranslatableTableScanExecutor;
import org.apache.shardingsphere.infra.federation.executor.common.CommonExecuteDataContext;
import org.apache.shardingsphere.infra.federation.executor.common.table.CommonTableScanExecutorContext;
import org.apache.shardingsphere.infra.federation.optimizer.ShardingSphereOptimizer;
import org.apache.shardingsphere.infra.federation.optimizer.context.OptimizerContext;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContextFactory;
import org.apache.shardingsphere.infra.federation.optimizer.executor.TableScanExecutor;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.translatable.TranslatableSchema;
import org.apache.shardingsphere.infra.federation.optimizer.planner.QueryOptimizePlannerFactory;
import org.apache.shardingsphere.infra.metadata.database.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class AdvancedFederationExecutor
implements FederationExecutor {
    private final String databaseName;
    private final String schemaName;
    private final OptimizerContext optimizerContext;
    private final ShardingSphereRuleMetaData globalRuleMetaData;
    private final ConfigurationProperties props;
    private final JDBCExecutor jdbcExecutor;
    private final EventBusContext eventBusContext;
    private ResultSet resultSet;

    public AdvancedFederationExecutor(String databaseName, String schemaName, OptimizerContext optimizerContext, ShardingSphereRuleMetaData globalRuleMetaData, ConfigurationProperties props, JDBCExecutor jdbcExecutor, EventBusContext eventBusContext) {
        this.databaseName = databaseName;
        this.schemaName = schemaName;
        this.optimizerContext = optimizerContext;
        this.globalRuleMetaData = globalRuleMetaData;
        this.props = props;
        this.jdbcExecutor = jdbcExecutor;
        this.eventBusContext = eventBusContext;
    }

    @Override
    public ResultSet executeQuery(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> callback, FederationContext federationContext) throws SQLException {
        SQLStatementContext sqlStatementContext = federationContext.getQueryContext().getSqlStatementContext();
        Preconditions.checkArgument((boolean)(sqlStatementContext instanceof SelectStatementContext), (Object)"SQL statement context must be select statement context.");
        ShardingSphereSchema schema = federationContext.getDatabases().get(this.databaseName.toLowerCase()).getSchema(this.schemaName);
        TranslatableSchema translatableSchema = this.createTranslatableSchema(prepareEngine, schema, callback, federationContext);
        Map<String, Object> parameters = this.createParameters(federationContext.getQueryContext().getParameters());
        Enumerator enumerator = this.execute(sqlStatementContext.getSqlStatement(), translatableSchema, parameters).enumerator();
        this.resultSet = new FederationResultSet((Enumerator<Object[]>)enumerator, schema, (AbstractSchema)translatableSchema, sqlStatementContext);
        return this.resultSet;
    }

    private Map<String, Object> createParameters(List<Object> parameters) {
        HashMap<String, Object> result = new HashMap<String, Object>(parameters.size(), 1.0f);
        int index = 0;
        for (Object each : parameters) {
            result.put("?" + index++, each);
        }
        return result;
    }

    private TranslatableSchema createTranslatableSchema(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, ShardingSphereSchema schema, JDBCExecutorCallback<? extends ExecuteResult> callback, FederationContext federationContext) {
        CommonTableScanExecutorContext executorContext = new CommonTableScanExecutorContext(this.databaseName, this.schemaName, this.props, federationContext);
        TranslatableTableScanExecutor executor = new TranslatableTableScanExecutor(prepareEngine, this.jdbcExecutor, callback, this.optimizerContext, this.globalRuleMetaData, executorContext, this.eventBusContext);
        return new TranslatableSchema(this.schemaName, schema, (TableScanExecutor)executor);
    }

    private Enumerable<Object[]> execute(SQLStatement sqlStatement, TranslatableSchema translatableSchema, Map<String, Object> parameters) {
        CalciteConnectionConfigImpl connectionConfig = new CalciteConnectionConfigImpl(OptimizerPlannerContextFactory.createConnectionProperties());
        JavaTypeFactoryImpl relDataTypeFactory = new JavaTypeFactoryImpl();
        CalciteCatalogReader catalogReader = OptimizerPlannerContextFactory.createCatalogReader((String)this.schemaName, (Schema)translatableSchema, (RelDataTypeFactory)relDataTypeFactory, (CalciteConnectionConfig)connectionConfig);
        SqlValidator validator = OptimizerPlannerContextFactory.createValidator((CalciteCatalogReader)catalogReader, (RelDataTypeFactory)relDataTypeFactory, (CalciteConnectionConfig)connectionConfig);
        SqlToRelConverter converter = OptimizerPlannerContextFactory.createConverter((CalciteCatalogReader)catalogReader, (SqlValidator)validator, (RelDataTypeFactory)relDataTypeFactory);
        RelNode bestPlan = new ShardingSphereOptimizer(converter, QueryOptimizePlannerFactory.createHepPlannerWithoutCalc(), QueryOptimizePlannerFactory.createHepPlannerWithCalc()).optimize(sqlStatement);
        Bindable executablePlan = EnumerableInterpretable.toBindable(Collections.emptyMap(), null, (EnumerableRel)((EnumerableRel)bestPlan), (EnumerableRel.Prefer)EnumerableRel.Prefer.ARRAY);
        return executablePlan.bind((DataContext)new CommonExecuteDataContext(validator, converter, parameters));
    }

    @Override
    public ResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public void close() throws SQLException {
        if (null != this.resultSet) {
            this.resultSet.close();
        }
    }
}

