/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.executor.advanced.resultset;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.shardingsphere.infra.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.util.ResultSetUtil;
import org.apache.shardingsphere.infra.federation.executor.advanced.resultset.AbstractUnsupportedOperationResultSet;
import org.apache.shardingsphere.infra.federation.executor.advanced.resultset.FederationResultSetMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;

public final class FederationResultSet
extends AbstractUnsupportedOperationResultSet {
    private static final String ASCII = "Ascii";
    private static final String UNICODE = "Unicode";
    private static final String BINARY = "Binary";
    private final Enumerator<Object[]> enumerator;
    private final Map<String, Integer> columnLabelAndIndexMap;
    private final FederationResultSetMetaData resultSetMetaData;
    private Object[] currentRows;
    private boolean wasNull;
    private boolean closed;

    public FederationResultSet(Enumerator<Object[]> enumerator, ShardingSphereSchema schema, AbstractSchema filterableSchema, SQLStatementContext<?> sqlStatementContext) {
        this.enumerator = enumerator;
        this.columnLabelAndIndexMap = this.createColumnLabelAndIndexMap(sqlStatementContext);
        this.resultSetMetaData = new FederationResultSetMetaData(schema, filterableSchema, (RelDataTypeFactory)new JavaTypeFactoryImpl(), (SelectStatementContext)sqlStatementContext);
    }

    private Map<String, Integer> createColumnLabelAndIndexMap(SQLStatementContext<?> sqlStatementContext) {
        SelectStatementContext selectStatementContext = (SelectStatementContext)sqlStatementContext;
        List projections = selectStatementContext.getProjectionsContext().getExpandProjections();
        HashMap<String, Integer> result = new HashMap<String, Integer>(projections.size(), 1.0f);
        for (int columnIndex = 1; columnIndex <= projections.size(); ++columnIndex) {
            result.put(((Projection)projections.get(columnIndex - 1)).getColumnLabel().toLowerCase(), columnIndex);
        }
        return result;
    }

    @Override
    public boolean next() throws SQLException {
        boolean result = this.enumerator.moveNext();
        this.currentRows = result ? (Object[])this.enumerator.current() : new Object[]{};
        return result;
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
        this.enumerator.close();
        this.currentRows = null;
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return (String)ResultSetUtil.convertValue((Object)this.getValue(columnIndex, String.class), String.class);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return (Boolean)ResultSetUtil.convertValue((Object)this.getValue(columnIndex, Boolean.TYPE), Boolean.TYPE);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return (Byte)ResultSetUtil.convertValue((Object)this.getValue(columnIndex, Byte.TYPE), Byte.TYPE);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return (Short)ResultSetUtil.convertValue((Object)this.getValue(columnIndex, Short.TYPE), Short.TYPE);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return (Integer)ResultSetUtil.convertValue((Object)this.getValue(columnIndex, Integer.TYPE), Integer.TYPE);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return (Long)ResultSetUtil.convertValue((Object)this.getValue(columnIndex, Long.TYPE), Long.TYPE);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return ((Float)ResultSetUtil.convertValue((Object)this.getValue(columnIndex, Float.TYPE), Float.TYPE)).floatValue();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return (Double)ResultSetUtil.convertValue((Object)this.getValue(columnIndex, Double.TYPE), Double.TYPE);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return (BigDecimal)ResultSetUtil.convertValue((Object)this.getValue(columnIndex, BigDecimal.class), BigDecimal.class);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return (BigDecimal)ResultSetUtil.convertValue((Object)this.getValue(columnIndex, BigDecimal.class), BigDecimal.class);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return (byte[])ResultSetUtil.convertValue((Object)this.getValue(columnIndex, byte[].class), byte[].class);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return (Date)ResultSetUtil.convertValue((Object)this.getValue(columnIndex, Date.class), Date.class);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return (Date)ResultSetUtil.convertValue((Object)this.getCalendarValue(columnIndex, Date.class, cal), Date.class);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.getIndexFromColumnLabelAndIndexMap(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return (Time)ResultSetUtil.convertValue((Object)this.getValue(columnIndex, Time.class), Time.class);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return (Time)ResultSetUtil.convertValue((Object)this.getCalendarValue(columnIndex, Time.class, cal), Time.class);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.getIndexFromColumnLabelAndIndexMap(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return (Timestamp)ResultSetUtil.convertValue((Object)this.getValue(columnIndex, Timestamp.class), Timestamp.class);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return (Timestamp)ResultSetUtil.convertValue((Object)this.getCalendarValue(columnIndex, Timestamp.class, cal), Timestamp.class);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.getIndexFromColumnLabelAndIndexMap(columnLabel), cal);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getInputStream(ASCII);
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.getInputStream(UNICODE);
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.getInputStream(BINARY);
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getValue(columnIndex, Object.class);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this.getIndexFromColumnLabelAndIndexMap(columnLabel);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return (Reader)this.getValue(columnIndex, Reader.class);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() {
        return 0;
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return (Blob)this.getValue(columnIndex, Blob.class);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return (Clob)this.getValue(columnIndex, Clob.class);
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        return (Array)this.getValue(columnIndex, Array.class);
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return (URL)this.getValue(columnIndex, URL.class);
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return (SQLXML)this.getValue(columnIndex, SQLXML.class);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getSQLXML(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    private Integer getIndexFromColumnLabelAndIndexMap(String columnLabel) throws SQLFeatureNotSupportedException {
        Integer result = this.columnLabelAndIndexMap.get(columnLabel.toLowerCase());
        if (null == result) {
            throw new SQLFeatureNotSupportedException(String.format("can't get index from columnLabel[%s].", columnLabel));
        }
        return result;
    }

    private Object getValue(int columnIndex, Class<?> type) throws SQLException {
        if (Blob.class == type || Clob.class == type || Reader.class == type || InputStream.class == type || SQLXML.class == type) {
            throw new SQLFeatureNotSupportedException(String.format("Get value from `%s`", type.getName()));
        }
        Object result = this.currentRows[columnIndex - 1];
        this.wasNull = null == result;
        return result;
    }

    private Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) {
        Object result = this.currentRows[columnIndex - 1];
        this.wasNull = null == result;
        return result;
    }

    private InputStream getInputStream(String type) throws SQLException {
        throw new SQLFeatureNotSupportedException(String.format("Get input stream from `%s`", type));
    }
}

