/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.executor.common.row;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import lombok.Generated;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.util.exception.sql.SQLWrapperException;

public final class CommonRowEnumerator
implements Enumerator<Object[]> {
    private final MergedResult queryResult;
    private final QueryResultMetaData metaData;
    private final Collection<Statement> statements;
    private Object[] currentRow;

    public Object[] current() {
        return this.currentRow;
    }

    public boolean moveNext() {
        try {
            return this.moveNext0();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    private boolean moveNext0() throws SQLException {
        if (this.queryResult.next()) {
            this.setCurrentRow();
            return true;
        }
        return false;
    }

    private void setCurrentRow() throws SQLException {
        this.currentRow = new Object[this.metaData.getColumnCount()];
        for (int i = 0; i < this.metaData.getColumnCount(); ++i) {
            this.currentRow[i] = this.queryResult.getValue(i + 1, Object.class);
        }
    }

    public void reset() {
    }

    public void close() {
        try {
            for (Statement each : this.statements) {
                each.close();
            }
            this.currentRow = null;
        }
        catch (SQLException ex) {
            throw new SQLWrapperException(ex);
        }
    }

    @Generated
    public CommonRowEnumerator(MergedResult queryResult, QueryResultMetaData metaData, Collection<Statement> statements) {
        this.queryResult = queryResult;
        this.metaData = metaData;
        this.statements = statements;
    }
}

