/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.federation.optimizer.context.OptimizerContext;
import org.apache.shardingsphere.infra.federation.optimizer.converter.SQLNodeConverterEngine;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ShardingSphereOptimizer {
    private final OptimizerContext context;

    public RelNode optimize(String databaseName, String schemaName, SQLStatement sqlStatement) {
        try {
            SqlNode sqlNode = SQLNodeConverterEngine.convertToSQLNode(sqlStatement);
            SqlNode validNode = this.context.getPlannerContexts().get(databaseName).getValidators().get(schemaName).validate(sqlNode);
            RelDataType resultType = this.context.getPlannerContexts().get(databaseName).getValidators().get(schemaName).getValidatedNodeType(sqlNode);
            RelNode queryPlan = this.context.getPlannerContexts().get((Object)databaseName).getConverters().get((Object)schemaName).convertQuery((SqlNode)validNode, (boolean)false, (boolean)true).rel;
            return this.optimize(databaseName, schemaName, queryPlan, resultType);
        }
        catch (UnsupportedOperationException ex) {
            throw new ShardingSphereException((Exception)ex);
        }
    }

    private RelNode optimize(String databaseName, String schemaName, RelNode queryPlan, RelDataType resultType) {
        RelOptPlanner planner = this.context.getPlannerContexts().get(databaseName).getConverters().get(schemaName).getCluster().getPlanner();
        RelNode node = planner.changeTraits(queryPlan, this.context.getPlannerContexts().get(databaseName).getConverters().get(schemaName).getCluster().traitSet().replace((RelTrait)EnumerableConvention.INSTANCE));
        RelRoot root = this.constructRoot(node, resultType);
        Program program = Programs.standard();
        return program.run(planner, root.rel, this.getDesireRootTraitSet(root), (List)ImmutableList.of(), (List)ImmutableList.of());
    }

    private RelRoot constructRoot(RelNode node, RelDataType resultType) {
        RelDataType rowType = node.getRowType();
        List fields = Pair.zip((List)ImmutableIntList.identity((int)rowType.getFieldCount()), (List)rowType.getFieldNames());
        RelCollation collation = node instanceof Sort ? ((Sort)node).collation : RelCollations.EMPTY;
        return new RelRoot(node, resultType, SqlKind.SELECT, fields, collation, new ArrayList());
    }

    private RelTraitSet getDesireRootTraitSet(RelRoot root) {
        return root.rel.getTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE).replace((RelTrait)root.collation).simplify();
    }

    @Generated
    public ShardingSphereOptimizer(OptimizerContext context) {
        this.context = context;
    }

    @Generated
    public OptimizerContext getContext() {
        return this.context;
    }
}

