/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.converter.segment.from.impl;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class SimpleTableConverter
implements SQLSegmentConverter<SimpleTableSegment, SqlNode> {
    @Override
    public Optional<SqlNode> convertToSQLNode(SimpleTableSegment segment) {
        TableNameSegment tableName = segment.getTableName();
        ArrayList<String> names = new ArrayList<String>();
        if (segment.getOwner().isPresent()) {
            names.add(((OwnerSegment)segment.getOwner().get()).getIdentifier().getValue());
        }
        names.add(tableName.getIdentifier().getValue());
        SqlIdentifier tableNameSQLNode = new SqlIdentifier(names, SqlParserPos.ZERO);
        if (segment.getAlias().isPresent()) {
            SqlIdentifier aliasSQLNode = new SqlIdentifier((String)segment.getAlias().get(), SqlParserPos.ZERO);
            return Optional.of(new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, new SqlNode[]{tableNameSQLNode, aliasSQLNode}, SqlParserPos.ZERO));
        }
        return Optional.of(tableNameSQLNode);
    }

    @Override
    public Optional<SimpleTableSegment> convertToSQLSegment(SqlNode sqlNode) {
        SqlBasicCall sqlBasicCall;
        if (sqlNode instanceof SqlBasicCall && (sqlBasicCall = (SqlBasicCall)sqlNode).getOperator().equals((Object)SqlStdOperatorTable.AS)) {
            String name = ((SqlNode)sqlBasicCall.getOperandList().get(0)).toString();
            SimpleTableSegment tableSegment = new SimpleTableSegment(new TableNameSegment(this.getStartIndex(sqlNode), this.getStopIndex(sqlNode), new IdentifierValue(name)));
            SqlNode alias = (SqlNode)sqlBasicCall.getOperandList().get(1);
            tableSegment.setAlias(new AliasSegment(this.getStartIndex(alias), this.getStopIndex(alias), new IdentifierValue(alias.toString())));
            return Optional.of(tableSegment);
        }
        if (sqlNode instanceof SqlIdentifier) {
            ImmutableList names = ((SqlIdentifier)sqlNode).names;
            SimpleTableSegment simpleTableSegment = new SimpleTableSegment(new TableNameSegment(this.getStartIndex(sqlNode), this.getStopIndex(sqlNode), new IdentifierValue((String)names.get(names.size() - 1))));
            if (2 == names.size()) {
                simpleTableSegment.setOwner(new OwnerSegment(this.getStartIndex(sqlNode), this.getStartIndex(sqlNode) + ((String)names.get(0)).length() - 1, new IdentifierValue((String)names.get(0))));
            }
            return Optional.of(simpleTableSegment);
        }
        return Optional.empty();
    }
}

