/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.metadata;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.avatica.SqlType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.shardingsphere.infra.metadata.schema.model.ColumnMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;

public final class FederationTableMetaData {
    private static final RelDataTypeFactory REL_DATA_TYPE_FACTORY = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
    private final String name;
    private final RelProtoDataType relProtoDataType;
    private final List<String> columnNames;

    public FederationTableMetaData(String name, TableMetaData tableMetaData) {
        this.name = name;
        this.relProtoDataType = this.createRelProtoDataType(tableMetaData);
        this.columnNames = tableMetaData.getColumns().values().stream().map(ColumnMetaData::getName).collect(Collectors.toList());
    }

    private RelProtoDataType createRelProtoDataType(TableMetaData tableMetaData) {
        RelDataTypeFactory.FieldInfoBuilder fieldInfo = REL_DATA_TYPE_FACTORY.builder();
        for (ColumnMetaData each : tableMetaData.getColumns().values()) {
            fieldInfo.add(each.getName(), this.getRelDataType(each));
        }
        return RelDataTypeImpl.proto((RelDataType)fieldInfo.build());
    }

    private RelDataType getRelDataType(ColumnMetaData columnMetaData) {
        Class sqlTypeClass = SqlType.valueOf((int)columnMetaData.getDataType()).clazz;
        RelDataType javaType = REL_DATA_TYPE_FACTORY.createJavaType(sqlTypeClass);
        return REL_DATA_TYPE_FACTORY.createTypeWithNullability(javaType, true);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public RelProtoDataType getRelProtoDataType() {
        return this.relProtoDataType;
    }

    @Generated
    public List<String> getColumnNames() {
        return this.columnNames;
    }
}

