/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.context.planner;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.sql2rel.StandardConvertletTable;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContext;
import org.apache.shardingsphere.infra.federation.optimizer.planner.QueryOptimizePlannerFactory;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;

public final class OptimizerPlannerContextFactory {
    public static Map<String, OptimizerPlannerContext> create(Map<String, ShardingSphereDatabase> databases) {
        ConcurrentHashMap<String, OptimizerPlannerContext> result = new ConcurrentHashMap<String, OptimizerPlannerContext>(databases.size(), 1.0f);
        for (Map.Entry<String, ShardingSphereDatabase> entry : databases.entrySet()) {
            result.put(entry.getKey(), new OptimizerPlannerContext(QueryOptimizePlannerFactory.createHepPlanner()));
        }
        return result;
    }

    public static Properties createConnectionProperties() {
        Properties result = new Properties();
        result.setProperty(CalciteConnectionProperty.TIME_ZONE.camelName(), "UTC");
        return result;
    }

    public static CalciteCatalogReader createCatalogReader(String schemaName, Schema schema, RelDataTypeFactory relDataTypeFactory, CalciteConnectionConfig connectionConfig) {
        CalciteSchema rootSchema = CalciteSchema.createRootSchema((boolean)true);
        rootSchema.add(schemaName, schema);
        return new CalciteCatalogReader(rootSchema, Collections.singletonList(schemaName), relDataTypeFactory, connectionConfig);
    }

    public static SqlValidator createValidator(CalciteCatalogReader catalogReader, RelDataTypeFactory relDataTypeFactory, CalciteConnectionConfig connectionConfig) {
        SqlValidator.Config validatorConfig = SqlValidator.Config.DEFAULT.withLenientOperatorLookup(connectionConfig.lenientOperatorLookup()).withConformance(connectionConfig.conformance()).withDefaultNullCollation(connectionConfig.defaultNullCollation()).withIdentifierExpansion(true);
        return SqlValidatorUtil.newValidator((SqlOperatorTable)SqlStdOperatorTable.instance(), (SqlValidatorCatalogReader)catalogReader, (RelDataTypeFactory)relDataTypeFactory, (SqlValidator.Config)validatorConfig);
    }

    public static SqlToRelConverter createConverter(CalciteCatalogReader catalogReader, SqlValidator validator, RelDataTypeFactory relDataTypeFactory) {
        RelOptTable.ViewExpander expander = (rowType, queryString, schemaPath, viewPath) -> null;
        SqlToRelConverter.Config converterConfig = SqlToRelConverter.config().withTrimUnusedFields(true);
        RelOptCluster cluster = RelOptCluster.create((RelOptPlanner)QueryOptimizePlannerFactory.createVolcanoPlanner(), (RexBuilder)new RexBuilder(relDataTypeFactory));
        return new SqlToRelConverter(expander, validator, (Prepare.CatalogReader)catalogReader, cluster, (SqlRexConvertletTable)StandardConvertletTable.INSTANCE, converterConfig);
    }

    @Generated
    private OptimizerPlannerContextFactory() {
    }
}

