/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.merge;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.sql.QueryResult;
import org.apache.shardingsphere.infra.merge.engine.ResultProcessEngine;
import org.apache.shardingsphere.infra.merge.engine.decorator.ResultDecorator;
import org.apache.shardingsphere.infra.merge.engine.decorator.ResultDecoratorEngine;
import org.apache.shardingsphere.infra.merge.engine.merger.ResultMerger;
import org.apache.shardingsphere.infra.merge.engine.merger.ResultMergerEngine;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.transparent.TransparentMergedResult;
import org.apache.shardingsphere.infra.metadata.model.physical.model.schema.PhysicalSchemaMetaData;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.ordered.OrderedSPIRegistry;

public final class MergeEngine {
    private final DatabaseType databaseType;
    private final PhysicalSchemaMetaData schemaMetaData;
    private final ConfigurationProperties props;
    private final Map<ShardingSphereRule, ResultProcessEngine> engines;

    public MergeEngine(DatabaseType databaseType, PhysicalSchemaMetaData schemaMetaData, ConfigurationProperties props, Collection<ShardingSphereRule> rules) {
        this.databaseType = databaseType;
        this.schemaMetaData = schemaMetaData;
        this.props = props;
        this.engines = OrderedSPIRegistry.getRegisteredServices(rules, ResultProcessEngine.class);
    }

    public MergedResult merge(List<QueryResult> queryResults, SQLStatementContext<?> sqlStatementContext) throws SQLException {
        Optional<MergedResult> mergedResult = this.executeMerge(queryResults, sqlStatementContext);
        Optional<MergedResult> result = mergedResult.isPresent() ? Optional.of(this.decorate(mergedResult.get(), sqlStatementContext)) : this.decorate(queryResults.get(0), sqlStatementContext);
        return result.orElseGet(() -> new TransparentMergedResult((QueryResult)queryResults.get(0)));
    }

    private Optional<MergedResult> executeMerge(List<QueryResult> queryResults, SQLStatementContext<?> sqlStatementContext) throws SQLException {
        for (Map.Entry<ShardingSphereRule, ResultProcessEngine> entry : this.engines.entrySet()) {
            if (!(entry.getValue() instanceof ResultMergerEngine)) continue;
            ResultMerger resultMerger = ((ResultMergerEngine)entry.getValue()).newInstance(this.databaseType, entry.getKey(), this.props, sqlStatementContext);
            return Optional.of(resultMerger.merge(queryResults, sqlStatementContext, this.schemaMetaData));
        }
        return Optional.empty();
    }

    private MergedResult decorate(MergedResult mergedResult, SQLStatementContext<?> sqlStatementContext) throws SQLException {
        MergedResult result = null;
        for (Map.Entry<ShardingSphereRule, ResultProcessEngine> entry : this.engines.entrySet()) {
            if (!(entry.getValue() instanceof ResultDecoratorEngine)) continue;
            ResultDecorator resultDecorator = ((ResultDecoratorEngine)entry.getValue()).newInstance(this.databaseType, this.schemaMetaData, entry.getKey(), this.props, sqlStatementContext);
            result = null == result ? resultDecorator.decorate(mergedResult, sqlStatementContext, this.schemaMetaData) : resultDecorator.decorate(result, sqlStatementContext, this.schemaMetaData);
        }
        return null == result ? mergedResult : result;
    }

    private Optional<MergedResult> decorate(QueryResult queryResult, SQLStatementContext<?> sqlStatementContext) throws SQLException {
        MergedResult result = null;
        for (Map.Entry<ShardingSphereRule, ResultProcessEngine> entry : this.engines.entrySet()) {
            if (!(entry.getValue() instanceof ResultDecoratorEngine)) continue;
            ResultDecorator resultDecorator = ((ResultDecoratorEngine)entry.getValue()).newInstance(this.databaseType, this.schemaMetaData, entry.getKey(), this.props, sqlStatementContext);
            result = null == result ? resultDecorator.decorate(queryResult, sqlStatementContext, this.schemaMetaData) : resultDecorator.decorate(result, sqlStatementContext, this.schemaMetaData);
        }
        return Optional.ofNullable(result);
    }

    static {
        ShardingSphereServiceLoader.register(ResultProcessEngine.class);
    }
}

