/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.merge;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.merge.engine.ResultProcessEngine;
import org.apache.shardingsphere.infra.merge.engine.decorator.ResultDecorator;
import org.apache.shardingsphere.infra.merge.engine.decorator.ResultDecoratorEngine;
import org.apache.shardingsphere.infra.merge.engine.decorator.impl.TransparentResultDecorator;
import org.apache.shardingsphere.infra.merge.engine.merger.ResultMerger;
import org.apache.shardingsphere.infra.merge.engine.merger.ResultMergerEngine;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.transparent.TransparentMergedResult;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.infra.util.spi.type.ordered.OrderedSPILoader;

public final class MergeEngine {
    private final ShardingSphereDatabase database;
    private final ConfigurationProperties props;
    private final Map<ShardingSphereRule, ResultProcessEngine> engines;
    private final ConnectionContext connectionContext;

    public MergeEngine(ShardingSphereDatabase database, ConfigurationProperties props, ConnectionContext connectionContext) {
        this.database = database;
        this.props = props;
        this.engines = OrderedSPILoader.getServices(ResultProcessEngine.class, (Collection)database.getRuleMetaData().getRules());
        this.connectionContext = connectionContext;
    }

    public MergedResult merge(List<QueryResult> queryResults, SQLStatementContext sqlStatementContext) throws SQLException {
        Optional<MergedResult> mergedResult = this.executeMerge(queryResults, sqlStatementContext);
        Optional<MergedResult> result = mergedResult.isPresent() ? Optional.of(this.decorate(mergedResult.get(), sqlStatementContext)) : this.decorate(queryResults.get(0), sqlStatementContext);
        return result.orElseGet(() -> new TransparentMergedResult((QueryResult)queryResults.get(0)));
    }

    private Optional<MergedResult> executeMerge(List<QueryResult> queryResults, SQLStatementContext sqlStatementContext) throws SQLException {
        for (Map.Entry<ShardingSphereRule, ResultProcessEngine> entry : this.engines.entrySet()) {
            if (!(entry.getValue() instanceof ResultMergerEngine)) continue;
            ResultMerger resultMerger = ((ResultMergerEngine)entry.getValue()).newInstance(this.database.getName(), this.database.getProtocolType(), entry.getKey(), this.props, sqlStatementContext);
            return Optional.of(resultMerger.merge(queryResults, sqlStatementContext, this.database, this.connectionContext));
        }
        return Optional.empty();
    }

    private MergedResult decorate(MergedResult mergedResult, SQLStatementContext sqlStatementContext) throws SQLException {
        MergedResult result = null;
        for (Map.Entry<ShardingSphereRule, ResultProcessEngine> entry : this.engines.entrySet()) {
            if (!(entry.getValue() instanceof ResultDecoratorEngine)) continue;
            ResultDecorator resultDecorator = this.getResultDecorator(sqlStatementContext, entry);
            result = null == result ? resultDecorator.decorate(mergedResult, sqlStatementContext, entry.getKey()) : resultDecorator.decorate(result, sqlStatementContext, entry.getKey());
        }
        return null == result ? mergedResult : result;
    }

    private Optional<MergedResult> decorate(QueryResult queryResult, SQLStatementContext sqlStatementContext) throws SQLException {
        MergedResult result = null;
        for (Map.Entry<ShardingSphereRule, ResultProcessEngine> entry : this.engines.entrySet()) {
            if (!(entry.getValue() instanceof ResultDecoratorEngine)) continue;
            ResultDecorator resultDecorator = this.getResultDecorator(sqlStatementContext, entry);
            result = null == result ? resultDecorator.decorate(queryResult, sqlStatementContext, entry.getKey()) : resultDecorator.decorate(result, sqlStatementContext, entry.getKey());
        }
        return Optional.ofNullable(result);
    }

    private ResultDecorator getResultDecorator(SQLStatementContext sqlStatementContext, Map.Entry<ShardingSphereRule, ResultProcessEngine> entry) {
        return (ResultDecorator)((ResultDecoratorEngine)entry.getValue()).newInstance(this.database, entry.getKey(), this.props, sqlStatementContext).orElseGet(TransparentResultDecorator::new);
    }
}

