/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.optimize;

import lombok.Generated;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.shardingsphere.infra.optimize.context.OptimizeContext;
import org.apache.shardingsphere.sql.parser.exception.SQLParsingException;

public final class ShardingSphereOptimizer {
    private final OptimizeContext context;

    public RelNode optimize(String sql) throws SQLParsingException {
        try {
            SqlNode sqlNode = SqlParser.create((String)sql, (SqlParser.Config)this.context.getParserConfig()).parseQuery();
            SqlNode validNode = this.context.getValidator().validate(sqlNode);
            RelNode logicPlan = this.context.getRelConverter().convertQuery((SqlNode)validNode, (boolean)false, (boolean)true).rel;
            return this.optimize(logicPlan);
        }
        catch (SqlParseException ex) {
            throw new SQLParsingException(ex.getMessage());
        }
    }

    private RelNode optimize(RelNode logicPlan) {
        RelOptPlanner planner = this.context.getRelConverter().getCluster().getPlanner();
        planner.setRoot(planner.changeTraits(logicPlan, this.context.getRelConverter().getCluster().traitSet().replace((RelTrait)EnumerableConvention.INSTANCE)));
        return planner.findBestExp();
    }

    @Generated
    public ShardingSphereOptimizer(OptimizeContext context) {
        this.context = context;
    }

    @Generated
    public OptimizeContext getContext() {
        return this.context;
    }
}

