/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.optimize.core.metadata;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.optimize.core.metadata.FederateTableMetadata;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.type.DataSourceContainedRule;

public final class FederateSchemaMetadata {
    @Generated
    private final Object $lock = new Object[0];
    private final String name;
    private final Map<String, FederateTableMetadata> tables = new LinkedHashMap<String, FederateTableMetadata>();

    @Deprecated
    public FederateSchemaMetadata(String name, ShardingSphereMetaData metaData) throws SQLException {
        this.name = name;
        this.initTables(metaData);
    }

    public FederateSchemaMetadata(String name, Map<String, TableMetaData> metaData) {
        this.name = name;
        for (Map.Entry<String, TableMetaData> entry : metaData.entrySet()) {
            this.tables.put(entry.getKey(), new FederateTableMetadata(entry.getKey(), entry.getValue()));
        }
    }

    private void initTables(ShardingSphereMetaData metaData) throws SQLException {
        Collection<DataNodeContainedRule> dataNodeRules = this.getDataNodeContainedRules(metaData);
        Map<String, Collection<DataNode>> tableDataNodes = this.getTableDataNodes(dataNodeRules);
        Map<String, Collection<String>> dataSourceRules = this.getDataSourceRules(metaData);
        for (Map.Entry<String, Collection<DataNode>> entry : tableDataNodes.entrySet()) {
            this.tables.put(entry.getKey(), new FederateTableMetadata(entry.getKey(), metaData.getResource().getDataSources(), dataSourceRules, entry.getValue(), metaData.getResource().getDatabaseType()));
        }
    }

    private Collection<DataNodeContainedRule> getDataNodeContainedRules(ShardingSphereMetaData metaData) {
        LinkedList<DataNodeContainedRule> result = new LinkedList<DataNodeContainedRule>();
        for (ShardingSphereRule each : metaData.getRuleMetaData().getRules()) {
            if (!(each instanceof DataNodeContainedRule)) continue;
            result.add((DataNodeContainedRule)each);
        }
        return result;
    }

    private Map<String, Collection<String>> getDataSourceRules(ShardingSphereMetaData metaData) {
        LinkedHashMap<String, Collection<String>> result = new LinkedHashMap<String, Collection<String>>();
        for (ShardingSphereRule each : metaData.getRuleMetaData().getRules()) {
            if (!(each instanceof DataSourceContainedRule)) continue;
            result.putAll(((DataSourceContainedRule)each).getDataSourceMapper());
        }
        return result;
    }

    private Map<String, Collection<DataNode>> getTableDataNodes(Collection<DataNodeContainedRule> dataNodeRules) {
        LinkedHashMap<String, Collection<DataNode>> result = new LinkedHashMap<String, Collection<DataNode>>();
        for (DataNodeContainedRule each : dataNodeRules) {
            result.putAll(each.getAllDataNodes());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renew(String tableName, TableMetaData metaData) {
        Object object = this.$lock;
        synchronized (object) {
            this.tables.put(tableName, new FederateTableMetadata(tableName, metaData));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String tableName) {
        Object object = this.$lock;
        synchronized (object) {
            this.tables.remove(tableName);
        }
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, FederateTableMetadata> getTables() {
        return this.tables;
    }
}

