/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.optimize.core.metadata;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.schema.builder.loader.TableMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.schema.model.ColumnMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;

public final class FederateTableMetadata {
    private final String name;
    private final RelProtoDataType relProtoDataType;

    public FederateTableMetadata(String name, TableMetaData tableMetaData) {
        this.name = name;
        this.relProtoDataType = this.createRelDataType(tableMetaData);
    }

    @Deprecated
    public FederateTableMetadata(String name, Map<String, DataSource> dataSources, Map<String, Collection<String>> dataSourceRules, Collection<DataNode> tableDataNodes, DatabaseType databaseType) throws SQLException {
        this.name = name;
        this.relProtoDataType = this.createRelDataType(this.createTableMetaData(dataSources, dataSourceRules, tableDataNodes, databaseType));
    }

    private TableMetaData createTableMetaData(Map<String, DataSource> dataSources, Map<String, Collection<String>> dataSourceRules, Collection<DataNode> tableDataNodes, DatabaseType databaseType) throws SQLException {
        DataNode dataNode = tableDataNodes.iterator().next();
        Optional tableMetaData = TableMetaDataLoader.load((DataSource)this.getActualDataSource(dataSources, dataSourceRules, dataNode.getDataSourceName()), (String)dataNode.getTableName(), (DatabaseType)databaseType);
        return tableMetaData.orElseGet(TableMetaData::new);
    }

    private RelProtoDataType createRelDataType(TableMetaData tableMetaData) {
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataTypeFactory.FieldInfoBuilder fieldInfo = typeFactory.builder();
        for (Map.Entry entry : tableMetaData.getColumns().entrySet()) {
            SqlTypeName sqlTypeName = SqlTypeName.getNameForJdbcType((int)((ColumnMetaData)entry.getValue()).getDataType());
            fieldInfo.add((String)entry.getKey(), null == sqlTypeName ? typeFactory.createUnknownType() : typeFactory.createTypeWithNullability(typeFactory.createSqlType(sqlTypeName), true));
        }
        return RelDataTypeImpl.proto((RelDataType)fieldInfo.build());
    }

    private DataSource getActualDataSource(Map<String, DataSource> dataSources, Map<String, Collection<String>> dataSourceRules, String logicDataSource) {
        String result = logicDataSource;
        if (dataSourceRules.containsKey(logicDataSource)) {
            result = dataSourceRules.get(logicDataSource).iterator().next();
        }
        return dataSources.get(result);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public RelProtoDataType getRelProtoDataType() {
        return this.relProtoDataType;
    }
}

