/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.optimize.core.metadata.refresher.type;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.schema.builder.SchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.schema.builder.TableMetaDataBuilder;
import org.apache.shardingsphere.infra.metadata.schema.builder.loader.TableMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.optimize.core.metadata.FederateSchemaMetadata;
import org.apache.shardingsphere.infra.optimize.core.metadata.refresher.FederateRefresher;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.type.TableContainedRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterTableStatement;

public final class AlterTableStatementFederateRefresher
implements FederateRefresher<AlterTableStatement> {
    @Override
    public void refresh(FederateSchemaMetadata schema, Collection<String> routeDataSourceNames, AlterTableStatement sqlStatement, SchemaBuilderMaterials materials) throws SQLException {
        String tableName = sqlStatement.getTable().getTableName().getIdentifier().getValue();
        if (sqlStatement.getRenameTable().isPresent()) {
            String renameTableName = ((SimpleTableSegment)sqlStatement.getRenameTable().get()).getTableName().getIdentifier().getValue();
            TableMetaData tableMetaData = this.buildTableMetaData(routeDataSourceNames, materials, renameTableName);
            schema.renew(renameTableName, tableMetaData);
            schema.remove(tableName);
        } else {
            TableMetaData tableMetaData = this.buildTableMetaData(routeDataSourceNames, materials, tableName);
            schema.renew(tableName, tableMetaData);
        }
    }

    private TableMetaData buildTableMetaData(Collection<String> routeDataSourceNames, SchemaBuilderMaterials materials, String tableName) throws SQLException {
        if (!this.containsInTableContainedRule(tableName, materials)) {
            return this.loadTableMetaData(tableName, routeDataSourceNames, materials);
        }
        return TableMetaDataBuilder.build((String)tableName, (SchemaBuilderMaterials)materials).orElse(new TableMetaData());
    }

    private boolean containsInTableContainedRule(String tableName, SchemaBuilderMaterials materials) {
        for (ShardingSphereRule each : materials.getRules()) {
            if (!(each instanceof TableContainedRule) || !((TableContainedRule)each).getTables().contains(tableName)) continue;
            return true;
        }
        return false;
    }

    private TableMetaData loadTableMetaData(String tableName, Collection<String> routeDataSourceNames, SchemaBuilderMaterials materials) throws SQLException {
        for (String routeDataSourceName : routeDataSourceNames) {
            Optional tableMetaDataOptional;
            DataSource dataSource = (DataSource)materials.getDataSourceMap().get(routeDataSourceName);
            Optional optional = tableMetaDataOptional = Objects.isNull(dataSource) ? Optional.empty() : TableMetaDataLoader.load((DataSource)dataSource, (String)tableName, (DatabaseType)materials.getDatabaseType());
            if (!tableMetaDataOptional.isPresent()) continue;
            return (TableMetaData)tableMetaDataOptional.get();
        }
        return new TableMetaData();
    }
}

