/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.optimize.context.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.optimize.context.parser.OptimizerParserContext;
import org.apache.shardingsphere.infra.optimize.context.parser.dialect.OptimizerSQLDialectBuilderFactory;

public final class OptimizerParserContextFactory {
    public static Map<String, OptimizerParserContext> create(Map<String, ShardingSphereMetaData> metaDataMap) {
        HashMap<String, OptimizerParserContext> result = new HashMap<String, OptimizerParserContext>();
        for (Map.Entry<String, ShardingSphereMetaData> entry : metaDataMap.entrySet()) {
            DatabaseType databaseType = entry.getValue().getResource().getDatabaseType();
            result.put(entry.getKey(), new OptimizerParserContext(databaseType, OptimizerParserContextFactory.createSQLDialectProperties(databaseType)));
        }
        return result;
    }

    private static Properties createSQLDialectProperties(DatabaseType databaseType) {
        Properties result = new Properties();
        result.setProperty(CalciteConnectionProperty.TIME_ZONE.camelName(), "UTC");
        result.putAll((Map<?, ?>)OptimizerSQLDialectBuilderFactory.build(databaseType, result));
        return result;
    }

    @Generated
    public OptimizerParserContextFactory() {
    }
}

