/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.optimize.converter.segment.projection.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.optimize.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.sql.parser.sql.common.constant.AggregationType;
import org.apache.shardingsphere.sql.parser.sql.common.constant.QuoteCharacter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;

public final class AggregationProjectionConverter
implements SQLSegmentConverter<AggregationProjectionSegment, SqlBasicCall> {
    private static final Map<String, SqlAggFunction> REGISTRY = new TreeMap<String, SqlAggFunction>(String.CASE_INSENSITIVE_ORDER);

    private static void register(SqlAggFunction sqlAggFunction) {
        REGISTRY.put(sqlAggFunction.getName(), sqlAggFunction);
    }

    @Override
    public Optional<SqlBasicCall> convertToSQLNode(AggregationProjectionSegment segment) {
        if (null == segment) {
            return Optional.empty();
        }
        List parameters = Splitter.on((String)",").trimResults().splitToList((CharSequence)SQLUtil.getExpressionWithoutOutsideParentheses((String)segment.getInnerExpression()));
        return Optional.of(new SqlBasicCall((SqlOperator)this.convertOperator(segment.getType().name()), new SqlNode[]{SqlIdentifier.star((List)parameters, (SqlParserPos)SqlParserPos.ZERO, Collections.singletonList(SqlParserPos.ZERO))}, SqlParserPos.ZERO));
    }

    @Override
    public Optional<AggregationProjectionSegment> convertToSQLSegment(SqlBasicCall sqlBasicCall) {
        if (null == sqlBasicCall) {
            return Optional.empty();
        }
        AggregationType aggregationType = AggregationType.valueOf((String)sqlBasicCall.getOperator().getName());
        String innerExpression = this.getInnerExpression(sqlBasicCall);
        return Optional.of(new AggregationProjectionSegment(this.getStartIndex((SqlNode)sqlBasicCall), this.getStopIndex((SqlNode)sqlBasicCall), aggregationType, innerExpression));
    }

    private String getInnerExpression(SqlBasicCall sqlBasicCall) {
        String params = sqlBasicCall.getOperandList().stream().map(SqlNode::toString).collect(Collectors.joining(", "));
        return QuoteCharacter.PARENTHESES.wrap(params);
    }

    private SqlAggFunction convertOperator(String operator) {
        Preconditions.checkState((boolean)REGISTRY.containsKey(operator), (String)"Unsupported SQL operator: `%s`", (Object)operator);
        return REGISTRY.get(operator);
    }

    static {
        AggregationProjectionConverter.register(SqlStdOperatorTable.MAX);
        AggregationProjectionConverter.register(SqlStdOperatorTable.MIN);
        AggregationProjectionConverter.register(SqlStdOperatorTable.SUM);
        AggregationProjectionConverter.register(SqlStdOperatorTable.COUNT);
        AggregationProjectionConverter.register(SqlStdOperatorTable.AVG);
    }
}

