/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.parser;

import com.google.common.util.concurrent.UncheckedExecutionException;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.apache.shardingsphere.distsql.parser.engine.api.DistSQLStatementParserEngine;
import org.apache.shardingsphere.infra.parser.sql.SQLStatementParserEngine;
import org.apache.shardingsphere.infra.parser.sql.SQLStatementParserEngineFactory;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.sql.parser.exception.SQLParsingException;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;

public final class ShardingSphereSQLParserEngine {
    private final SQLStatementParserEngine sqlStatementParserEngine;
    private final DistSQLStatementParserEngine distSQLStatementParserEngine;

    public ShardingSphereSQLParserEngine(String databaseTypeName, SQLParserRule sqlParserRule) {
        this.sqlStatementParserEngine = SQLStatementParserEngineFactory.getSQLStatementParserEngine(databaseTypeName, sqlParserRule);
        this.distSQLStatementParserEngine = new DistSQLStatementParserEngine();
    }

    public SQLStatement parse(String sql, boolean useCache) {
        return this.parse0(sql, useCache);
    }

    private SQLStatement parse0(String sql, boolean useCache) {
        try {
            return this.sqlStatementParserEngine.parse(sql, useCache);
        }
        catch (UncheckedExecutionException | ParseCancellationException | SQLParsingException originalEx) {
            try {
                String trimSQL = SQLUtil.trimComment((String)sql);
                return this.distSQLStatementParserEngine.parse(trimSQL);
            }
            catch (SQLParsingException ignored) {
                throw originalEx;
            }
        }
    }
}

