/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.parser.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import lombok.Generated;
import org.apache.shardingsphere.infra.parser.cache.SQLStatementCacheLoader;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.sql.parser.api.CacheOption;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class SQLStatementCacheBuilder {
    public static LoadingCache<String, SQLStatement> build(SQLParserRule sqlParserRule, String databaseType) {
        CacheOption sqlStatementCache = sqlParserRule.getSqlStatementCache();
        return CacheBuilder.newBuilder().softValues().initialCapacity(sqlStatementCache.getInitialCapacity()).maximumSize(sqlStatementCache.getMaximumSize()).concurrencyLevel(sqlStatementCache.getConcurrencyLevel()).build((CacheLoader)new SQLStatementCacheLoader(databaseType, sqlParserRule));
    }

    @Generated
    private SQLStatementCacheBuilder() {
    }
}

